/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Closeable;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.orbada.gui.comps.table.DataTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class ExplainPlanPanel
extends JPanel
implements Closeable {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private DataTable data;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBar;

    public ExplainPlanPanel(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void updatePlan(String sqlText) {
        this.data.getQuery().setDatabase(this.database);
        try {
            Query query = this.database.createQuery();
            query.setSqlText(sqlText);
            Command command = this.database.createCommand();
            command.execute("EXPLAIN \n" + query.getPreparedSqlText());
            if (command.getStatement() != null) {
                this.data.getQuery().close();
                this.data.getQuery().setResultSet(command.getStatement().getResultSet());
            }
        }
        catch (Exception ex) {
            MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void close() throws IOException {
        this.data.getQuery().close();
    }

    private void initComponents() {
        this.statusBar = new QueryTableStatusBar();
        this.jScrollPane1 = new JScrollPane();
        this.data = new DataTable();
        this.setLayout(new BorderLayout());
        this.statusBar.setTable((QueryTable)this.data);
        this.add((Component)this.statusBar, "South");
        this.jScrollPane1.setViewportView((Component)this.data);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

