/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.HtmlEditorPane;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.HtmlUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.variant.Variant;

public class HelpPanelView
extends JPanel
implements IRootTabObjectInfo {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private IViewAccesibilities accesibilities;
    private ISettings settings;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private ToolButton buttonSearch;
    private Action cmRefresh;
    private Action cmSearch;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JSplitPane split;
    private QueryTableStatusBar statusBar;
    private ViewTable table;
    private HtmlEditorPane textHelp;
    private ComboBox textSearch;
    private JToolBar toolBar;

    public HelpPanelView(IViewAccesibilities accesibilities) {
        this.accesibilities = accesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.settings = this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "mysql-help-panel");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                HelpPanelView.this.split.setDividerLocation(HelpPanelView.this.settings.getValue("split", Long.valueOf((long)((float)HelpPanelView.this.split.getWidth() * 0.3f))).intValue());
                HelpPanelView.this.textSearch.requestFocusInWindow();
            }
        });
        this.textSearch.setModel(new DefaultComboBoxModel());
        SwingUtil.addAction((JComponent)((JTextField)this.textSearch.getEditor().getEditorComponent()), (javax.swing.Action)this.cmSearch);
        ((JTextField)this.textSearch.getEditor().getEditorComponent()).getComponentPopupMenu().addSeparator();
        ((JTextField)this.textSearch.getEditor().getEditorComponent()).getComponentPopupMenu().add((javax.swing.Action)this.cmSearch);
        this.textHelp.setFont(new Font("Monospaced", 0, this.textHelp.getFont().getSize()));
        ((JTextField)this.textSearch.getEditor().getEditorComponent()).addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.table));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                HelpPanelView.this.fillTextHelp();
            }
        });
        this.table.getQuery().setDatabase(this.getDatabase());
        try {
            this.table.addColumn((TableColumn)new QueryTableColumn("name", this.stringManager.getString("help-topic"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.table.addColumn((TableColumn)new QueryTableColumn("category_name", this.stringManager.getString("category-name"), 250));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.table, (JButton)this.buttonActions, this.menuActions, "mysql-help-actions");
    }

    private void fillTextHelp() {
        if (this.table.getSelectedRow() >= 0) {
            try {
                this.table.getQuery().getRecord(this.table.getSelectedRow());
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                sb.append("<style>");
                sb.append("  body { font-family: " + this.textHelp.getFont().getFontName() + ", Tahoma, Arial, serif; font-size: 9px; padding: 5px;}");
                sb.append("</style>");
                sb.append("<head></head>");
                sb.append("<body>");
                sb.append("<h1>" + this.table.getQuery().fieldByName("name").getString() + "</h1>");
                sb.append(this.stringManager.getString("category-name-dd") + " <b>" + this.table.getQuery().fieldByName("category_name").getString() + "</b>");
                sb.append("<br>" + this.stringManager.getString("see-also-dd") + " <a href=\"" + this.table.getQuery().fieldByName("url").getString() + "\">" + this.table.getQuery().fieldByName("url").getString() + "</a>");
                sb.append("<hr>");
                String desc = HtmlUtil.prepareText((String)this.table.getQuery().fieldByName("description").getString());
                desc = desc.replace("\n", "<br>");
                desc = desc.replace(" ", "&nbsp;");
                sb.append(desc);
                sb.append("</body>");
                sb.append("</html>");
                this.textHelp.setText(sb.toString());
            }
            catch (Exception ex) {
                this.textHelp.setText(ex.getMessage());
                ExceptionUtil.processException((Throwable)ex);
            }
        } else {
            this.textHelp.setText("");
        }
    }

    private String getFilterText() {
        return this.textSearch.getText();
    }

    private void setFilterText(String text) {
        this.textSearch.setText(text);
    }

    private void addTextToList(String text) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.textSearch.getModel();
        int index = model.getIndexOf(text);
        if (index != -1) {
            model.removeElementAt(index);
        }
        model.insertElementAt(text, 0);
        if (model.getSize() > 10) {
            model.removeElementAt(model.getSize() - 1);
        }
        this.setFilterText(text);
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String objectName = null;
            if (this.table.getQuery().isActive() && this.table.getSelectedRow() >= 0) {
                this.table.getQuery().getRecord(this.table.getSelectedRow());
                objectName = this.table.getQuery().fieldByName("name").getString();
            }
            this.refresh(objectName);
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void refresh(String objectName) {
        try {
            int column = this.table.getSelectedColumn();
            int index = Math.max(0, this.table.getSelectedRow());
            this.table.getQuery().close();
            if (StringUtil.isEmpty((String)this.textSearch.getText())) {
                this.table.getQuery().setSqlText(Sql.getHelpList(null));
            } else {
                this.table.getQuery().setSqlText(Sql.getHelpList("h.name = :search\n    or h.category_name = :search\n    or exists (select null from mysql.help_relation r, mysql.help_keyword k where r.help_topic_id = h.help_topic_id and k.help_keyword_id = r.help_keyword_id and k.name = :search)"));
                this.table.getQuery().paramByName("search").setString(this.textSearch.getText());
            }
            this.table.getQuery().open();
            if (objectName != null && this.table.getQuery().locate("name", new Variant(objectName))) {
                this.table.changeSelection(this.table.getQuery().getCurrentRecord().getIndex(), column);
            } else if (!this.table.getQuery().isEmpty()) {
                this.table.changeSelection(Math.min(index, this.table.getRowCount() - 1), column);
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.settings.setValue("split", Long.valueOf(this.split.getDividerLocation()));
        this.table.getQuery().close();
        this.accesibilities = null;
        this.settings.store();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.cmSearch = new Action();
        this.split = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.table = new ViewTable();
        this.statusBar = new QueryTableStatusBar();
        this.jPanel2 = new JPanel();
        this.toolBar = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSearch = new ComboBox();
        this.buttonSearch = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jPanel5 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.textHelp = new HtmlEditorPane(){

            protected HyperlinkListener createHyperLinkListener() {
                return null;
            }

            public void setPage(URL page) {
            }
        };
        this.cmRefresh.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/refresh16.gif")));
        this.cmRefresh.setText(this.stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(this.stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpPanelView.this.cmRefreshActionPerformed(evt);
            }
        });
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 0));
        this.cmSearch.setSmallIcon((Icon)new ImageIcon(this.getClass().getResource("/pl/mpak/res/icons/find_source.gif")));
        this.cmSearch.setText(this.stringManager.getString("cmSearch-text"));
        this.cmSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpPanelView.this.cmSearchActionPerformed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                HelpPanelView.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.split.setBorder(null);
        this.split.setDividerLocation(300);
        this.split.setContinuousLayout(true);
        this.split.setOneTouchExpandable(true);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.table);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBar.setShowFieldType(false);
        this.statusBar.setShowOpenTime(false);
        this.statusBar.setTable((QueryTable)this.table);
        this.jPanel1.add((Component)this.statusBar, "South");
        this.jPanel4.add((Component)this.jPanel1, "Center");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonRefresh);
        this.jPanel3.setLayout(new FlowLayout(1, 2, 3));
        this.jLabel1.setText(this.stringManager.getString("search-dd"));
        this.jPanel3.add(this.jLabel1);
        this.textSearch.setEditable(true);
        this.textSearch.setPreferredSize(new Dimension(150, 22));
        this.jPanel3.add((Component)this.textSearch);
        this.toolBar.add(this.jPanel3);
        this.buttonSearch.setAction((javax.swing.Action)this.cmSearch);
        this.buttonSearch.setHorizontalTextPosition(0);
        this.buttonSearch.setVerticalTextPosition(3);
        this.toolBar.add((Component)this.buttonSearch);
        this.toolBar.add(this.jSeparator1);
        this.toolBar.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBar);
        this.jPanel4.add((Component)this.jPanel2, "North");
        this.split.setLeftComponent(this.jPanel4);
        this.jPanel5.setLayout(new BorderLayout());
        this.textHelp.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                HelpPanelView.this.textHelpHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.textHelp);
        this.jPanel5.add((Component)this.jScrollPane2, "Center");
        this.split.setRightComponent(this.jPanel5);
        this.add((Component)this.split, "Center");
    }

    private void formComponentShown(ComponentEvent evt) {
        if (!this.table.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void textHelpHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void cmSearchActionPerformed(ActionEvent evt) {
        if (!"".equals(this.getFilterText())) {
            this.addTextToList(this.getFilterText());
        }
        this.refresh();
    }
}

