/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.OrbadaTabbedPane;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.SearchEvent;
import pl.mpak.sky.gui.swing.comp.SearchListener;
import pl.mpak.sky.gui.swing.comp.SearchPanel;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class SearchObjectPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private SearchPanel searchPanel;

    public SearchObjectPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.searchPanel = new SearchPanel();
        this.searchPanel.setTable(this.getTable());
        this.searchPanel.addSearchListener(new SearchListener(){

            public void search(SearchEvent e) {
                SearchObjectPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.searchPanel);
        super.init();
    }

    public OrbadaTabbedPane getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return MySQLDbInfoProvider.getCurrentDatabase(this.getDatabase());
    }

    public String getPanelName() {
        return "mysql-search-objects";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("object_schema", this.stringManager.getString("database"), 150), new QueryTableColumn("object_type", this.stringManager.getString("object-type"), 150), new QueryTableColumn("object_name", this.stringManager.getString("object-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("table_schema", this.stringManager.getString("table-database"), 150), new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 150), new QueryTableColumn("comment", this.stringManager.getString("comment"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getObjectsSearch(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("object_name", this.stringManager.getString("object-name"), (String[])null), new SqlFilterDefComponent("object_type", this.stringManager.getString("object-type"), new String[]{"('FUNCTION', 'PROCEDURE', 'TABLE', 'VIEW', 'TRIGGER', 'INDEX')"}), new SqlFilterDefComponent("table_schema", this.stringManager.getString("table-database"), (String[])null), new SqlFilterDefComponent("table_name", this.stringManager.getString("table-name"), (String[])null)};
    }

    public String[] getSchemaList() {
        return MySQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("object_name").setString(this.searchPanel.getText());
    }
}

