/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.comp.RefreshEvent;
import pl.mpak.sky.gui.swing.comp.RefreshListener;
import pl.mpak.sky.gui.swing.comp.RefreshPanel;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;

public class SessionsPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private VersionID mySQLver;
    private boolean ge517;
    private RefreshPanel refreshPanel;

    public SessionsPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    protected void init() {
        this.mySQLver = new VersionID(MySQLDbInfoProvider.instance.getVersion(this.getDatabase()));
        this.ge517 = this.mySQLver.compare(5, 1, 7) >= 0;
        this.refreshPanel = new RefreshPanel();
        this.refreshPanel.addRefreshListener(new RefreshListener(){

            public void refresh(RefreshEvent e) {
                SessionsPanelView.this.refresh();
            }
        });
        this.getToolBar().add((Component)this.refreshPanel);
        super.init();
    }

    public void close() throws IOException {
        this.refreshPanel.cancel();
        super.close();
    }

    public Component getTabbedPane() {
        return null;
    }

    public String getCurrentSchemaName() {
        return null;
    }

    public String getPanelName() {
        return "mysql-sessions";
    }

    public String getSchemaColumnName() {
        return null;
    }

    public String getObjectColumnName() {
        return "id";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        ArrayList<QueryTableColumn> columns = new ArrayList<QueryTableColumn>();
        QueryTableCellRenderer renderer = new QueryTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    try {
                        if (SessionsPanelView.this.ge517 && "T".equals(SessionsPanelView.this.getQuery().fieldByName("THIS").getString())) {
                            label.setBackground(new Color(180, 205, 240));
                        } else if (value != null && value.toString().equalsIgnoreCase("Sleep")) {
                            label.setForeground(Color.GRAY);
                        }
                    }
                    catch (Exception ex) {
                        label.setText(label.getText() + " [" + ex.getMessage() + "]");
                    }
                }
                return label;
            }
        };
        columns.add(new QueryTableColumn("id", this.stringManager.getString("thread"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("user", this.stringManager.getString("user"), 100, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("host", this.stringManager.getString("host"), 150, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("db", this.stringManager.getString("database"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("command", this.stringManager.getString("command-type"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("time", this.stringManager.getString("time"), 50, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("state", this.stringManager.getString("state"), 80, (TableCellRenderer)renderer));
        columns.add(new QueryTableColumn("info", this.stringManager.getString("info"), 250, (TableCellRenderer)renderer));
        return columns.toArray(new QueryTableColumn[columns.size()]);
    }

    public String getSql(SqlFilter filter) {
        if (this.ge517) {
            return Sql.getProcessList(filter.getSqlText());
        }
        return Sql.getShowProcessList();
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        if (this.ge517) {
            return new SqlFilterDefComponent[]{new SqlFilterDefComponent("user", this.stringManager.getString("user"), (String[])null), new SqlFilterDefComponent("host", this.stringManager.getString("host"), (String[])null), new SqlFilterDefComponent("db", this.stringManager.getString("database"), (String[])null), new SqlFilterDefComponent("command", this.stringManager.getString("command-type"), (String[])null), new SqlFilterDefComponent("state", this.stringManager.getString("state"), (String[])null), new SqlFilterDefComponent("info", this.stringManager.getString("info"), (String[])null)};
        }
        return null;
    }

    public String[] getSchemaList() {
        return null;
    }
}

