/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.functions;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionParametersPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public FunctionParametersPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getTitle() {
        return this.stringManager.getString("FunctionParametersPanel-title");
    }

    public String getPanelName() {
        return "mysql-function-prameters";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "param_no";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("param_no", this.stringManager.getString("pos"), 30), new QueryTableColumn("param", this.stringManager.getString("parameter"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("param_type", this.stringManager.getString("mode"), 70, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY))};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getRoutineParameterList(filter.getSqlText());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("object_type").setString("FUNCTION");
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("param", this.stringManager.getString("parameter"), (String[])null), new SqlFilterDefComponent("param_type", this.stringManager.getString("mode"), new String[]{"", "'IN'", "'OUT'", "'INOUT'", "'RETURNS'"})};
    }
}

