/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.functions;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionPrivilegesPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public FunctionPrivilegesPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getTitle() {
        return this.stringManager.getString("FunctionPrivilegesPanel-title");
    }

    public String getPanelName() {
        return "mysql-function-privileges";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "object_name";
    }

    public String getPropColumnName() {
        return "privilege";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("grantee", this.stringManager.getString("grantee"), 150), new QueryTableColumn("privilege", this.stringManager.getString("privilege-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("grantor", this.stringManager.getString("grantor"), 150)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getRoutinePrivilegeList(filter.getSqlText());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("object_type").setString("FUNCTION");
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("grantee", this.stringManager.getString("grantee"), (String[])null), new SqlFilterDefComponent("privilege", this.stringManager.getString("privilege-type"), (String[])null), new SqlFilterDefComponent("grantor", this.stringManager.getString("grantor"), (String[])null)};
    }
}

