/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.functions;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.functions.FunctionTabbedPane;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.ParametrizedCommand;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class FunctionsPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public FunctionsPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new FunctionTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return MySQLDbInfoProvider.getCurrentDatabase(this.getDatabase());
    }

    public String getPanelName() {
        return "mysql-functions";
    }

    public String getObjectColumnName() {
        return "routine_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("routine_name", this.stringManager.getString("function-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("definer", this.stringManager.getString("definer"), 100), new QueryTableColumn("is_deterministic", this.stringManager.getString("is-deterministic"), 40), new QueryTableColumn("sql_data_access", this.stringManager.getString("sql-data-access"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("security_type", this.stringManager.getString("security-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("created", this.stringManager.getString("created"), 120), new QueryTableColumn("routine_comment", this.stringManager.getString("comment"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getProcedureList(filter.getSqlText());
    }

    public void extraSqlParameters(ParametrizedCommand qc) throws UseDBException {
        qc.paramByName("object_type").setString("FUNCTION");
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("routine_name", this.stringManager.getString("function-name"), (String[])null), new SqlFilterDefComponent("is_deterministic = 'YES'", this.stringManager.getString("is-deterministic"))};
    }

    public String[] getSchemaList() {
        return MySQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }
}

