/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.settings;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.services.MySQLTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TemplatesSettingsPanel
extends JPanel
implements ISettingsComponent {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private IApplication application;
    private ISettings settings;
    private JComboBox comboFunction;
    private JComboBox comboProcedure;
    private JComboBox comboTrigger;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public TemplatesSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Query query = InternalDatabase.get().createQuery();
        try {
            ArrayList<String> teplateList = new ArrayList<String>();
            query.setSqlText("select distinct tpl_name\n  from templates\n where (tpl_usr_id = :usr_id or tpl_usr_id is null)\n order by tpl_name");
            query.paramByName("usr_id").setString(this.application.getUserId());
            query.open();
            while (!query.eof()) {
                teplateList.add(query.fieldByName("tpl_name").getString());
                query.next();
            }
            this.comboFunction.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboProcedure.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
            this.comboTrigger.setModel(new DefaultComboBoxModel<Object>(teplateList.toArray()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        this.settings = this.application.getSettings(MySQLTemplatesSettingsProvider.settingsName);
        this.restoreSettings();
    }

    public void restoreSettings() {
        this.comboFunction.setSelectedItem(this.settings.getValue(MySQLTemplatesSettingsProvider.setFunction, "mysql-function"));
        this.comboProcedure.setSelectedItem(this.settings.getValue(MySQLTemplatesSettingsProvider.setProcedure, "mysql-procedure"));
        this.comboTrigger.setSelectedItem(this.settings.getValue(MySQLTemplatesSettingsProvider.setTrigger, "mysql-trigger"));
    }

    public void applySettings() {
        this.settings.setValue(MySQLTemplatesSettingsProvider.setFunction, this.comboFunction.getSelectedItem().toString());
        this.settings.setValue(MySQLTemplatesSettingsProvider.setProcedure, this.comboProcedure.getSelectedItem().toString());
        this.settings.setValue(MySQLTemplatesSettingsProvider.setTrigger, this.comboTrigger.getSelectedItem().toString());
        this.settings.store();
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.comboTrigger = new JComboBox();
        this.jLabel2 = new JLabel();
        this.comboFunction = new JComboBox();
        this.comboProcedure = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(this.stringManager.getString("trigger-dd"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("function-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("procedure-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboTrigger, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboFunction, 0, 285, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 172, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboProcedure, 0, 285, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.comboTrigger, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.comboFunction, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.comboProcedure, -2, -1, -2)).addContainerGap(265, Short.MAX_VALUE)));
    }
}

