/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.tables;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableColumnPrivilegesPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TableColumnPrivilegesPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getTitle() {
        return this.stringManager.getString("TableColumnPrivilegesPanel-title");
    }

    public String getPanelName() {
        return "mysql-table-columns-privileges";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getPropColumnName() {
        return "column_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("grantee", this.stringManager.getString("grantee"), 150), new QueryTableColumn("column_name", this.stringManager.getString("column-name"), 100, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("privilege_type", this.stringManager.getString("privilege-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("is_grantable", this.stringManager.getString("is-grantable"), 40)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getColumnPrivilegesList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("grantee", this.stringManager.getString("grantee"), (String[])null), new SqlFilterDefComponent("column_name", this.stringManager.getString("column-name"), (String[])null), new SqlFilterDefComponent("privilege_type", this.stringManager.getString("privilege-type"), (String[])null)};
    }
}

