/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.tables;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableConstraintsPanel
extends UniversalPropTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TableConstraintsPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getTitle() {
        return this.stringManager.getString("TableConstraintsPanel-title");
    }

    public String getPanelName() {
        return "mysql-table-constraints";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getPropColumnName() {
        return "constraint_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("constraint_name", this.stringManager.getString("constraint-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("constraint_type", this.stringManager.getString("constraint-type"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("columns", this.stringManager.getString("constraint-columns"), 200), new QueryTableColumn("referenced_table_schema", this.stringManager.getString("referenced-table-schema"), 100), new QueryTableColumn("referenced_table_name", this.stringManager.getString("referenced-table-name"), 100), new QueryTableColumn("ref_columns", this.stringManager.getString("ref-columns"), 150), new QueryTableColumn("update_rule", this.stringManager.getString("update-rule"), 200), new QueryTableColumn("delete_rule", this.stringManager.getString("delete-rule"), 200)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTableConstraintsList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("constraint_name", this.stringManager.getString("constraint-name"), (String[])null), new SqlFilterDefComponent("constraint_type", this.stringManager.getString("constraint-type"), new String[]{"", "'PRIMARY KEY'", "'UNIQUE'", "'UNIQUE'"}), new SqlFilterDefComponent("columns", this.stringManager.getString("constraint-columns"), (String[])null), new SqlFilterDefComponent("referenced_table_schema", this.stringManager.getString("referenced-table-schema"), (String[])null), new SqlFilterDefComponent("referenced_table_name", this.stringManager.getString("referenced-table-name"), (String[])null)};
    }
}

