/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.tables;

import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.util.SourceCreator;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalPropSourceTab;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableTriggersPanel
extends UniversalPropSourceTab {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TableTriggersPanel(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public String getTitle() {
        return this.stringManager.getString("TableTriggersPanel-title");
    }

    public String getPanelName() {
        return "mysql-table-triggers";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getPropColumnName() {
        return "trigger_name";
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("action_order", this.stringManager.getString("action-order"), 40), new QueryTableColumn("trigger_name", this.stringManager.getString("trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("action_timing", this.stringManager.getString("action-timing"), 120, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("event_manipulation", this.stringManager.getString("event-manipulation"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("action_orientation", this.stringManager.getString("action-orientation"), 120), new QueryTableColumn("action_condition", this.stringManager.getString("action-condition"), 120)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTableTriggersList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("trigger_name", this.stringManager.getString("trigger-name"), (String[])null), new SqlFilterDefComponent("action_timing", this.stringManager.getString("action-timing"), (String[])null), new SqlFilterDefComponent("event_manipulation", this.stringManager.getString("event-manipulation"), (String[])null), new SqlFilterDefComponent("action_orientation", this.stringManager.getString("action-orientation"), (String[])null)};
    }

    public void updateBody(OrbadaSyntaxTextArea textArea) {
        new SourceCreator(this.getDatabase(), (SyntaxTextArea)textArea).getSource(this.currentSchemaName, "TRIGGER", this.currentPropName);
    }
}

