/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.tables;

import java.awt.Component;
import javax.swing.table.TableCellRenderer;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.tables.TableTabbedPane;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.tabbed.UniversalViewTabs;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TablesPanelView
extends UniversalViewTabs {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public TablesPanelView(IViewAccesibilities accesibilities) {
        super(accesibilities);
    }

    public Component getTabbedPane() {
        return new TableTabbedPane(this.accesibilities);
    }

    public String getCurrentSchemaName() {
        return MySQLDbInfoProvider.getCurrentDatabase(this.getDatabase());
    }

    public String getPanelName() {
        return "mysql-tables";
    }

    public String getSchemaColumnName() {
        return "schema_name";
    }

    public String getObjectColumnName() {
        return "table_name";
    }

    public String getDescriptionColumnName() {
        return null;
    }

    public QueryTableColumn[] getTableColumns() {
        return new QueryTableColumn[]{new QueryTableColumn("table_name", this.stringManager.getString("table-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)), new QueryTableColumn("engine", this.stringManager.getString("engine"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("row_format", this.stringManager.getString("row-format"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.NAVY)), new QueryTableColumn("table_type", this.stringManager.getString("table-type"), 100), new QueryTableColumn("create_time", this.stringManager.getString("created"), 120), new QueryTableColumn("update_time", this.stringManager.getString("updated"), 120), new QueryTableColumn("table_comment", this.stringManager.getString("comment"), 250)};
    }

    public String getSql(SqlFilter filter) {
        return Sql.getTableList(filter.getSqlText());
    }

    public SqlFilterDefComponent[] getFilterDefComponent() {
        return new SqlFilterDefComponent[]{new SqlFilterDefComponent("table_name", this.stringManager.getString("table-name"), (String[])null), new SqlFilterDefComponent("engine", this.stringManager.getString("engine"), (String[])null), new SqlFilterDefComponent("row_format", this.stringManager.getString("row-format"), (String[])null), new SqlFilterDefComponent("table_type", this.stringManager.getString("table-type"), (String[])null)};
    }

    public String[] getSchemaList() {
        return MySQLDbInfoProvider.instance.getSchemas(this.getDatabase());
    }
}

