/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.util.helpers.DatabaseInfo;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DatabaseComboBoxModel
extends DefaultComboBoxModel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;

    public DatabaseComboBoxModel(Database database) {
        this.database = database;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change() {
        this.removeAllElements();
        try {
            Query query = this.database.createQuery(Sql.getDatabaseList());
            try {
                while (!query.eof()) {
                    this.addElement(new DatabaseInfo(query.fieldByName("schema_name").getString()));
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        catch (Exception ex) {
            MessageBox.show(null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void select(String databaseName, JComboBox combo) {
        if (databaseName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).toString().equalsIgnoreCase(databaseName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

