/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.util.helpers.EngineInfo;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class EngineComboBoxModel
extends DefaultComboBoxModel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;

    public EngineComboBoxModel(Database database) {
        this.database = database;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change() {
        this.removeAllElements();
        try {
            Query query = this.database.createQuery(Sql.getEngineList());
            try {
                while (!query.eof()) {
                    this.addElement(new EngineInfo(query.fieldByName("ENGINE").getString(), query.fieldByName("SUPPORT").getString(), query.fieldByName("COMMENT").getString(), StringUtil.toBoolean((String)query.fieldByName("TRANSACTIONS").getString()), StringUtil.toBoolean((String)query.fieldByName("XA").getString()), StringUtil.toBoolean((String)query.fieldByName("SAVEPOINTS").getString())));
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        catch (Exception ex) {
            MessageBox.show(null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void select(String engineName, JComboBox combo) {
        if (engineName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).toString().equalsIgnoreCase(engineName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

