/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.util;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.util.helpers.TableInfo;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class TableComboBoxModel
extends DefaultComboBoxModel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;

    public TableComboBoxModel(Database database) {
        this.database = database;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(String databaseName) {
        this.removeAllElements();
        try {
            Query query = this.database.createQuery(Sql.getTableList(null), false);
            try {
                query.paramByName("schema_name").setString(databaseName);
                query.open();
                while (!query.eof()) {
                    this.addElement(new TableInfo(query.fieldByName("table_schema").getString(), query.fieldByName("table_name").getString(), query.fieldByName("table_type").getString(), query.fieldByName("engine").getString(), query.fieldByName("row_format").getString(), query.fieldByName("create_time").getDate(), query.fieldByName("update_time").getDate(), query.fieldByName("table_comment").getString()));
                    query.next();
                }
            }
            finally {
                query.close();
            }
        }
        catch (Exception ex) {
            MessageBox.show(null, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
    }

    public void select(String tableName, JComboBox combo) {
        if (tableName != null) {
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).toString().equalsIgnoreCase(tableName)) continue;
                combo.setSelectedIndex(i);
                break;
            }
        } else if (this.getSize() > 0) {
            combo.setSelectedIndex(0);
        }
    }

    private void init() {
    }
}

