/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.util.DatabaseComboBoxModel;
import pl.mpak.orbada.mysql.gui.util.EngineComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CopyAsTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private String engine;
    private JCheckBox checkData;
    private ComboBox comboDatabases;
    private ComboBox comboEngine;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private TextField textNewTableName;
    private TextField textTableName;

    public CopyAsTableWizard(Database database, String databaseName, String tableName, String engine) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.engine = engine;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.textTableName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database));
        this.comboDatabases.setModel((ComboBoxModel)new DatabaseComboBoxModel(this.database));
        this.comboEngine.setModel((ComboBoxModel)new EngineComboBoxModel(this.database));
    }

    public void wizardShow() {
        ((DatabaseComboBoxModel)this.comboDatabases.getModel()).change();
        ((DatabaseComboBoxModel)this.comboDatabases.getModel()).select(this.databaseName, (JComboBox)this.comboDatabases);
        ((EngineComboBoxModel)this.comboEngine.getModel()).change();
        ((EngineComboBoxModel)this.comboEngine.getModel()).select(StringUtil.nvl((String)this.engine, (String)"MyISAM"), (JComboBox)this.comboEngine);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CopyAsTableWizard.this.textNewTableName.requestFocusInWindow();
            }
        });
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CopyAsTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CopyAsTableWizard-tab-title");
    }

    public String getSqlCode() {
        String newTableName = this.textNewTableName.getText();
        if ("".equals(newTableName)) {
            newTableName = this.tableName + "_" + String.format("%1$tY%1$tm%1$td%1$tH%1$tM%1$tS", System.currentTimeMillis());
        }
        this.getResultMap().put("new-table-name", newTableName);
        return "CREATE TABLE " + SQLUtil.createSqlName((String)this.comboDatabases.getSelectedItem().toString(), (Database)this.database) + "." + newTableName + " ENGINE=" + this.comboEngine.getText() + " AS\n" + "SELECT * FROM " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + (!this.checkData.isSelected() ? "\n WHERE 1 = 0" : "");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.textNewTableName = new TextField();
        this.jLabel6 = new JLabel();
        this.checkData = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.textTableName = new TextField();
        this.jLabel7 = new JLabel();
        this.comboDatabases = new ComboBox();
        this.comboEngine = new ComboBox();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("new-table-name-dd"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("new-table-database-dd"));
        this.checkData.setSelected(true);
        this.checkData.setText(this.stringManager.getString("copy-data-also"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-name-dd"));
        this.textTableName.setEditable(false);
        this.textTableName.setFocusable(false);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("table-engine-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTableName, -1, 291, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboDatabases, -1, 291, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboEngine, -1, 291, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkData).addComponent((Component)this.textNewTableName, -1, 291, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent((Component)this.comboDatabases, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent((Component)this.comboEngine, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textNewTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkData).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

