/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.mysql.gui.util.TableComboBoxModel;
import pl.mpak.orbada.mysql.gui.util.helpers.TableInfo;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateForeignKeyTableConstraintWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private String columnName;
    private JComboBox comboColumnForeignKey;
    private JComboBox comboColumnReference;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private JComboBox comboOnDelete;
    private JComboBox comboOnUpdate;
    private JComboBox comboTablesReferences;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JScrollPane jScrollPane1;
    private Table tableColumns;
    private TextField textName;
    private TextField textTableName;

    public CreateForeignKeyTableConstraintWizardPanel(Database database, String databaseName, String tableName) {
        this(database, databaseName, tableName, null);
    }

    public CreateForeignKeyTableConstraintWizardPanel(Database database, String databaseName, String tableName, String columnName) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{this.columnName, null}}, new String[]{this.stringManager.getString("foreign-key-columns"), this.stringManager.getString("reference-columns")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableColumns.setRowHeight(20);
        this.textTableName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database));
        this.comboColumnForeignKey = new JComboBox(new TableColumnComboBoxModel(this.database));
        this.comboColumnReference = new JComboBox(new TableColumnComboBoxModel(this.database));
        TableColumn tc = this.tableColumns.getColumnModel().getColumn(0);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnForeignKey));
        tc = this.tableColumns.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnReference));
        this.comboTablesReferences.addItemListener(new ItemListener(){
            TableInfo lastTable;

            public void itemStateChanged(ItemEvent e) {
                TableInfo ti;
                if (e.getStateChange() == 1 && e.getItem() != null && e.getItem() instanceof TableInfo && (!(ti = (TableInfo)e.getItem()).equals(this.lastTable) || this.lastTable == null)) {
                    ((TableColumnComboBoxModel)CreateForeignKeyTableConstraintWizardPanel.this.comboColumnReference.getModel()).change(CreateForeignKeyTableConstraintWizardPanel.this.databaseName, ti.getName());
                    this.lastTable = ti;
                }
            }
        });
    }

    public void wizardShow() {
        ((TableColumnComboBoxModel)this.comboColumnForeignKey.getModel()).change(this.databaseName, this.tableName);
        ((TableComboBoxModel)this.comboTablesReferences.getModel()).change(this.databaseName);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateForeignKeyTableConstraintWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateForeignKeyTableConstraintWizardPanel-tab-title");
    }

    public String getSqlCode() {
        String fkColumns = "";
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object column = this.tableColumns.getValueAt(i, 0);
            if (column == null) continue;
            if (!StringUtil.isEmpty((String)fkColumns)) {
                fkColumns = fkColumns + ", ";
            }
            fkColumns = fkColumns + SQLUtil.createSqlName((String)column.toString(), (Database)this.database);
        }
        String refColumns = "";
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object column = this.tableColumns.getValueAt(i, 1);
            if (column == null) continue;
            if (!StringUtil.isEmpty((String)refColumns)) {
                refColumns = refColumns + ", ";
            }
            refColumns = refColumns + SQLUtil.createSqlName((String)column.toString(), (Database)this.database);
        }
        String onDelete = StringUtil.isEmpty((String)this.comboOnDelete.getSelectedItem().toString().trim()) ? "" : "\n  ON DELETE " + this.comboOnDelete.getSelectedItem().toString();
        String onUpdate = StringUtil.isEmpty((String)this.comboOnUpdate.getSelectedItem().toString().trim()) ? "" : "\n  ON UPDATE " + this.comboOnUpdate.getSelectedItem().toString();
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + "\n" + "  ADD CONSTRAINT " + this.textName.getText() + "\n" + "  FOREIGN KEY " + this.textName.getText() + " (" + fkColumns + ")\n" + "  REFERENCES " + SQLUtil.createSqlName((String)this.comboTablesReferences.getSelectedItem().toString(), (Database)this.database) + " (" + refColumns + ")" + onDelete + onUpdate;
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.comboTablesReferences = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.jLabel6 = new JLabel();
        this.comboOnDelete = new JComboBox();
        this.jLabel7 = new JLabel();
        this.comboOnUpdate = new JComboBox();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.textTableName = new TextField();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/add8.gif")));
        this.cmAddRow.setText(this.stringManager.getString("cmAddRow-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateForeignKeyTableConstraintWizardPanel.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/remove8.gif")));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemoveRow-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateForeignKeyTableConstraintWizardPanel.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("constraint-table-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("constraint-name-dd"));
        this.comboTablesReferences.setModel(new TableComboBoxModel(this.database));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("reference-table-dd"));
        this.jLabel1.setText(this.stringManager.getString("foreign-key-column-dd"));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.stringManager.getString("delete-rule-dd"));
        this.comboOnDelete.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "NO ACTION", "CASCADE", "SET NULL", "RESTRICT"}));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(this.stringManager.getString("update-rule-dd"));
        this.comboOnUpdate.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "NO ACTION", "CASCADE", "SET NULL", "RESTRICT"}));
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.textTableName.setEditable(false);
        this.textTableName.setFocusable(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, 137, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 137, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 137, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textName, GroupLayout.Alignment.CENTER, -1, 294, Short.MAX_VALUE).addComponent((Component)this.textTableName, GroupLayout.Alignment.CENTER, -1, 294, Short.MAX_VALUE).addComponent(this.comboTablesReferences, GroupLayout.Alignment.CENTER, 0, 294, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(10, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING, -1, 141, Short.MAX_VALUE).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -2, 141, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboOnDelete, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE).addComponent(this.comboOnUpdate, GroupLayout.Alignment.TRAILING, 0, 324, Short.MAX_VALUE)).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonRemoveRow, -1, 75, Short.MAX_VALUE).addComponent(this.buttonAddRow, -1, 75, Short.MAX_VALUE)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(331, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.comboTablesReferences, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 178, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOnDelete, -2, 22, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.comboOnUpdate, -2, 22, -2)).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1) {
            this.tableColumns.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            this.tableColumns.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null && this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 1) != null) {
            ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{null, null});
        }
    }
}

