/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.db.Template;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.wizards.ParameterDefinitionWizard;
import pl.mpak.orbada.mysql.services.MySQLTemplatesSettingsProvider;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.script.SimpleSQLScript;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class CreateProcedureWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private ParameterDefinitionWizard parametrDefinition;
    private Template template;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTabbedPane tab;
    private TextField textDescription;
    private TextField textName;

    public CreateProcedureWizard(Database database, String databaseName) {
        this.database = database;
        this.databaseName = databaseName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.parametrDefinition = new ParameterDefinitionWizard(this.database);
        this.tab.addTab(this.parametrDefinition.getTabTitle(), (Component)((Object)this.parametrDefinition));
    }

    public void wizardShow() {
        ISettings oracle = Application.get().getSettings(MySQLTemplatesSettingsProvider.settingsName);
        this.template = new Template(Application.get().getOrbadaDatabase()).loadByName(oracle.getValue(MySQLTemplatesSettingsProvider.setProcedure, "mysql-procedure"));
        this.parametrDefinition.wizardShow();
    }

    public String getDialogTitle() {
        return this.stringManager.getString("CreateProcedureWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("CreateProcedureWizard-tab-title");
    }

    public String getSqlCode() {
        this.getResultMap().put("object_name", this.textName.getText());
        if (this.template == null) {
            return "CREATE PROCEDURE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.textName.getText(), (Database)this.database) + "(" + this.parametrDefinition.getSqlCode() + ")\n" + "BEGIN\n" + "END\n" + "/";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("&name", SQLUtil.createSqlName((String)this.databaseName, (String)this.textName.getText(), (Database)this.database));
        map.put("&parameters", this.parametrDefinition.getSqlCode());
        if (!StringUtil.isEmpty((String)this.textDescription.getText())) {
            map.put("pr&operties", "COMMENT '" + StringUtil.replaceString((String)this.textDescription.getText(), (String)"'", (String)"''") + "'");
        }
        map.put("&body", "");
        return this.template.expand(map) + "\n/";
    }

    public boolean execute() {
        SimpleSQLScript script = new SimpleSQLScript(this.database);
        this.getResultMap().put("name", this.textName.getText());
        if (!script.executeScript(this.getSqlCode())) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)script.getErrors(), (int)1, (int)0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.tab = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.jLabel4 = new JLabel();
        this.textDescription = new TextField();
        this.tab.setFocusable(false);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("procedure-name-dd"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.stringManager.getString("comment-dd"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, 141, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.textName, -2, 222, -2).addComponent((Component)this.textDescription, -1, 410, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent((Component)this.textDescription, -2, -1, -2)).addContainerGap(196, Short.MAX_VALUE)));
        this.tab.addTab(this.stringManager.getString("basic"), this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 580, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tab, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }
}

