/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DefaultValueTableColumnWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private String columnName;
    private String columnType;
    private String defaultValue;
    private JCheckBox checkDropDefault;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textDefaultValue;
    private TextField textName;

    public DefaultValueTableColumnWizard(Database database, String databaseName, String tableName, String columnName, String defaultValue) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.defaultValue = defaultValue;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void wizardShow() {
        this.textName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (String)this.columnName, (Database)this.database));
        this.textDefaultValue.setText(this.defaultValue == null ? "" : this.defaultValue);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("DefaultValueTableColumnWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("DefaultValueTableColumnWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + " ALTER COLUMN " + SQLUtil.createSqlName((String)this.columnName, (Database)this.database) + (this.checkDropDefault.isSelected() ? " DROP DEFAULT" : " SET DEFAULT " + this.textDefaultValue.getText());
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.textDefaultValue = new TextField();
        this.textName = new TextField();
        this.checkDropDefault = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("column-name-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("default-value-dd"));
        this.textName.setEditable(false);
        this.textName.setFocusable(false);
        this.checkDropDefault.setText(this.stringManager.getString("drop-default"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 224, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkDropDefault).addComponent((Component)this.textDefaultValue, -1, 224, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textDefaultValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDropDefault).addContainerGap(19, Short.MAX_VALUE)));
    }
}

