/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class NullNotNullTableColumnWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private String columnName;
    private String columnType;
    private String nullable;
    private JCheckBox checkNullable;
    private JLabel jLabel2;
    private TextField textName;

    public NullNotNullTableColumnWizard(Database database, String databaseName, String tableName, String columnName, String columnType, String nullable) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnType = columnType;
        this.nullable = nullable;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void wizardShow() {
        this.textName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (String)this.columnName, (Database)this.database));
        this.checkNullable.setSelected(StringUtil.toBoolean((String)this.nullable));
    }

    public String getDialogTitle() {
        return this.stringManager.getString("NullNotNullTableColumnWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("NullNotNullTableColumnWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + " MODIFY " + SQLUtil.createSqlName((String)this.columnName, (Database)this.database) + " " + this.columnType + (this.checkNullable.isSelected() ? " NULL" : " NOT NULL");
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.textName = new TextField();
        this.checkNullable = new JCheckBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("column-name-dd"));
        this.textName.setEditable(false);
        this.textName.setFocusable(false);
        this.checkNullable.setText(this.stringManager.getString("is-nullable-dd"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkNullable).addComponent((Component)this.textName, -1, 224, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkNullable).addContainerGap(12, Short.MAX_VALUE)));
    }
}

