/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.util.TableColumnComboBoxModel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class OrderByTableWizardPanel
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private JComboBox comboColumnPrimaryKey;
    private JButton buttonAddRow;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmRemoveRow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private Table tableColumns;
    private TextField textTableName;

    public OrderByTableWizardPanel(Database database, String databaseName, String tableName) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableColumns.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, ""}}, new String[]{this.stringManager.getString("key-columns"), this.stringManager.getString("order")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableColumns.setRowHeight(20);
        this.textTableName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database));
        this.comboColumnPrimaryKey = new JComboBox(new TableColumnComboBoxModel(this.database));
        TableColumn tc = this.tableColumns.getColumnModel().getColumn(0);
        tc.setCellEditor(new DefaultCellEditor(this.comboColumnPrimaryKey));
        tc = this.tableColumns.getColumnModel().getColumn(1);
        tc.setCellEditor(new DefaultCellEditor(new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"", "ASC", "DESC"}))));
        this.tableColumns.getColumnModel().getColumn(0).setWidth(100);
    }

    public void wizardShow() {
        ((TableColumnComboBoxModel)this.comboColumnPrimaryKey.getModel()).change(this.databaseName, this.tableName);
    }

    public String getDialogTitle() {
        return this.stringManager.getString("OrderByTableWizardPanel-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("OrderByTableWizardPanel-tab-title");
    }

    public String getSqlCode() {
        String oColumns = "";
        for (int i = 0; i < this.tableColumns.getRowCount(); ++i) {
            Object column = this.tableColumns.getValueAt(i, 0);
            if (column == null) continue;
            if (!StringUtil.isEmpty((String)oColumns)) {
                oColumns = oColumns + ", ";
            }
            oColumns = oColumns + SQLUtil.createSqlName((String)column.toString(), (Database)this.database);
            Object order = this.tableColumns.getValueAt(i, 1);
            if (order == null || StringUtil.isEmpty((String)order.toString())) continue;
            oColumns = oColumns + " " + order;
        }
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + "\n" + "  ORDER BY " + oColumns;
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.textTableName = new TextField();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/add8.gif")));
        this.cmAddRow.setText(this.stringManager.getString("cmAddRow-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrderByTableWizardPanel.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/remove8.gif")));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemoveRow-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OrderByTableWizardPanel.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-name-dd"));
        this.jLabel1.setText(this.stringManager.getString("order-columns-dd"));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.textTableName.setEditable(false);
        this.textTableName.setFocusable(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 287, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonRemoveRow, -1, 73, Short.MAX_VALUE).addComponent(this.buttonAddRow, -2, 73, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 114, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textTableName, -1, 248, Short.MAX_VALUE)).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textTableName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 242, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow))).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getRowCount() > 1) {
            this.tableColumns.getColumnModel().getColumn(0).getCellEditor().cancelCellEditing();
            ((DefaultTableModel)this.tableColumns.getModel()).removeRow(this.tableColumns.getRowCount() - 1);
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableColumns.getValueAt(this.tableColumns.getRowCount() - 1, 0) != null) {
            ((DefaultTableModel)this.tableColumns.getModel()).addRow(new Object[]{null, ""});
        }
    }
}

