/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pl.mpak.orbada.gui.comps.table.Table;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class ParameterDefinitionWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private int paramCount = 0;
    private JButton buttonAddRow;
    private JButton buttonMoveDown;
    private JButton buttonMoveUp;
    private JButton buttonRemoveRow;
    private Action cmAddRow;
    private Action cmMoveDown;
    private Action cmMoveUp;
    private Action cmRemoveRow;
    private JComboBox comboDataTypes;
    private JComboBox comboInOut;
    private JScrollPane jScrollPane1;
    private Table tableParameters;

    public ParameterDefinitionWizard(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tableParameters.setRowHeight(20);
        ++this.paramCount;
        this.tableParameters.setModel((TableModel)new DefaultTableModel(new Object[][]{{"PARAMETR_1", "VARCHAR(1000)", ""}}, new String[]{this.stringManager.getString("parameter-name"), this.stringManager.getString("parameter-type"), this.stringManager.getString("parameter-mode")}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableParameters.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboDataTypes));
        this.tableParameters.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.comboInOut));
        this.tableParameters.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.tableParameters.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.tableParameters.getColumnModel().getColumn(2).setPreferredWidth(50);
    }

    public void wizardShow() {
    }

    public String getDialogTitle() {
        return this.stringManager.getString("ParameterDefinitionWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("ParameterDefinitionWizard-tab-title");
    }

    public String getSqlCode() {
        StringBuffer columns = new StringBuffer();
        boolean addednl = false;
        for (int i = 0; i < this.tableParameters.getRowCount(); ++i) {
            Object name = this.tableParameters.getValueAt(i, 0);
            Object dataType = this.tableParameters.getValueAt(i, 1);
            Object inOutValue = this.tableParameters.getValueAt(i, 2);
            if (name == null || dataType == null) continue;
            if (columns.length() > 0) {
                if (!addednl) {
                    columns.insert(0, "\n  ");
                    addednl = true;
                }
                columns.append(",\n  ");
            }
            if (!StringUtil.isEmpty((String)inOutValue.toString().trim())) {
                columns.append(inOutValue.toString().trim() + " ");
            }
            columns.append(name);
            columns.append(" " + dataType);
        }
        return columns.toString();
    }

    public boolean execute() {
        return false;
    }

    private void cancelEdit() {
        this.tableParameters.getColumnModel().getColumn(1).getCellEditor().cancelCellEditing();
        this.tableParameters.getColumnModel().getColumn(2).getCellEditor().cancelCellEditing();
        this.tableParameters.getColumnModel().getColumn(4).getCellEditor().cancelCellEditing();
    }

    private void initComponents() {
        this.cmAddRow = new Action();
        this.cmRemoveRow = new Action();
        this.cmMoveDown = new Action();
        this.cmMoveUp = new Action();
        this.comboDataTypes = new JComboBox();
        this.comboInOut = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tableParameters = new Table();
        this.buttonAddRow = new JButton();
        this.buttonRemoveRow = new JButton();
        this.buttonMoveUp = new JButton();
        this.buttonMoveDown = new JButton();
        this.cmAddRow.setActionCommandKey("cmAddRow");
        this.cmAddRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/add8.gif")));
        this.cmAddRow.setText(this.stringManager.getString("cmAddRow-text"));
        this.cmAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterDefinitionWizard.this.cmAddRowActionPerformed(evt);
            }
        });
        this.cmRemoveRow.setActionCommandKey("cmRemoveRow");
        this.cmRemoveRow.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/remove8.gif")));
        this.cmRemoveRow.setText(this.stringManager.getString("cmRemoveRow-text"));
        this.cmRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterDefinitionWizard.this.cmRemoveRowActionPerformed(evt);
            }
        });
        this.cmMoveDown.setActionCommandKey("cmMoveDown");
        this.cmMoveDown.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/down10.gif")));
        this.cmMoveDown.setText(this.stringManager.getString("cmMoveDown-text"));
        this.cmMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterDefinitionWizard.this.cmMoveDownActionPerformed(evt);
            }
        });
        this.cmMoveUp.setActionCommandKey("cmMoveUp");
        this.cmMoveUp.setSmallIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pl/mpak/res/icons/up10.gif")));
        this.cmMoveUp.setText(this.stringManager.getString("cmMoveUp-text"));
        this.cmMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParameterDefinitionWizard.this.cmMoveUpActionPerformed(evt);
            }
        });
        this.comboDataTypes.setEditable(true);
        this.comboDataTypes.setModel(new DefaultComboBoxModel<String>(new String[]{"VARCHAR(100)", "VARCHAR(1000)", "VARCHAR(4000)", "SMALLINT", "MEDIUMINT", "INTEGER", "BIGINT", "FLOAT(M,D)", "DOUBLE(M,D)", "DOUBLE PRECISION(M,D)", "DECIMAL(M,D)", "DATE", "DATETIME", "TIMESTAMP", "CHAR(M)", "VARCHAR(M)", "BINARY(M)", "VARBINARY(M)", "TINYBLOB", "TINYTEXT", "BLOB(M)", "TEXT(M)", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT"}));
        this.comboInOut.setModel(new DefaultComboBoxModel<String>(new String[]{" ", "IN", "OUT", "IN OUT"}));
        this.setPreferredSize(new Dimension(600, 300));
        this.jScrollPane1.setMinimumSize(new Dimension(24, 100));
        this.tableParameters.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.tableParameters);
        this.buttonAddRow.setAction((javax.swing.Action)this.cmAddRow);
        this.buttonAddRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonRemoveRow.setAction((javax.swing.Action)this.cmRemoveRow);
        this.buttonRemoveRow.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveUp.setAction((javax.swing.Action)this.cmMoveUp);
        this.buttonMoveUp.setMargin(new Insets(2, 2, 2, 2));
        this.buttonMoveDown.setAction((javax.swing.Action)this.cmMoveDown);
        this.buttonMoveDown.setMargin(new Insets(2, 2, 2, 2));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 499, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonMoveUp, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonRemoveRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonAddRow, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.buttonMoveDown, -1, 75, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 278, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.buttonAddRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonRemoveRow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonMoveDown))).addContainerGap()));
    }

    private void cmRemoveRowActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getRowCount() > 0 && this.tableParameters.getSelectedRow() >= 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).removeRow(this.tableParameters.getSelectedRow());
        }
    }

    private void cmAddRowActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getRowCount() == 0 || this.tableParameters.getValueAt(this.tableParameters.getRowCount() - 1, 0) != null) {
            ++this.paramCount;
            ((DefaultTableModel)this.tableParameters.getModel()).addRow(new Object[]{"PARAMETR_" + this.paramCount, "VARCHAR(1000)", ""});
            this.tableParameters.changeSelection(this.tableParameters.getRowCount() - 1, this.tableParameters.getRowCount() - 1);
        }
    }

    private void cmMoveDownActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getSelectedRow() >= 0 && this.tableParameters.getSelectedRow() < this.tableParameters.getRowCount() - 1) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).moveRow(this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow() + 1);
            this.tableParameters.changeSelection(this.tableParameters.getSelectedRow() + 1, this.tableParameters.getSelectedRow() + 1);
        }
    }

    private void cmMoveUpActionPerformed(ActionEvent evt) {
        if (this.tableParameters.getSelectedRow() > 0) {
            this.cancelEdit();
            ((DefaultTableModel)this.tableParameters.getModel()).moveRow(this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow(), this.tableParameters.getSelectedRow() - 1);
            this.tableParameters.changeSelection(this.tableParameters.getSelectedRow() - 1, this.tableParameters.getSelectedRow() - 1);
        }
    }
}

