/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.gui.wizards;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class RenameTableWizard
extends SqlCodeWizardPanel {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);
    private Database database;
    private String databaseName;
    private String tableName;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private TextField textName;
    private TextField textOldName;

    public RenameTableWizard(Database database, String databaseName, String tableName) {
        this.database = database;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.initComponents();
        this.init();
    }

    private void init() {
    }

    public void wizardShow() {
        this.textOldName.setText(SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database));
    }

    public String getDialogTitle() {
        return this.stringManager.getString("RenameTableWizard-dialog-title");
    }

    public String getTabTitle() {
        return this.stringManager.getString("RenameTableWizard-tab-title");
    }

    public String getSqlCode() {
        return "ALTER TABLE " + SQLUtil.createSqlName((String)this.databaseName, (String)this.tableName, (Database)this.database) + " RENAME TO " + SQLUtil.createSqlName((String)this.databaseName, (String)this.textName.getText(), (Database)this.database);
    }

    public boolean execute() {
        try {
            this.database.executeCommand(this.getSqlCode());
            this.getResultMap().put("new-table-name", this.textName.getText());
            return true;
        }
        catch (Exception ex) {
            MessageBox.show((Component)((Object)this), (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.textName = new TextField();
        this.textOldName = new TextField();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("table-name-dd"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.stringManager.getString("new-table-name-dd"));
        this.textOldName.setEditable(false);
        this.textOldName.setFocusable(false);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textOldName, -1, 224, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textName, -1, 224, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.textOldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent((Component)this.textName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

