/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.AutotracePanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class MySQLAutotraceProvider
extends UniversalActionProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        if ("MySQL".equals(database.getDriverType())) {
            this.setShortCut(84, 2);
            this.setText("Statustyki po\u0142aczenia");
            this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/autotrace.gif"));
            this.setActionCommandKey("MySQLAutotraceProvider");
            this.addActionListener(this.createActionListener());
            return true;
        }
        return false;
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return "MySQL " + this.getText();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MySQLAutotraceProvider.this.openResultTab();
            }
        };
    }

    private void openResultTab() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            this.accessibilities.setSelectedTab((Component)panel);
        } else {
            AutotracePanel panel = new AutotracePanel(this.accessibilities.getViewAccesibilities().getDatabase());
            panel.afterSql();
            this.accessibilities.addResultTab(this.getText(), (JComponent)panel);
        }
    }

    private void beforeSql() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            panel.beforeSql();
        }
    }

    private void afterSql() {
        Component[] array = this.accessibilities.getResultTabs(AutotracePanel.class);
        if (array.length > 0) {
            AutotracePanel panel = (AutotracePanel)array[0];
            panel.afterSql();
        }
    }

    public void beforeOpenQuery(Query query) {
        this.beforeSql();
    }

    public void afterOpenQuery(Query query) {
        this.afterSql();
    }

    public void beforeExecuteCommand(Command command) {
        this.beforeSql();
    }

    public void afterExecuteCommand(Command command) {
        this.afterSql();
    }

    public String getGroupName() {
        return "MySQL";
    }
}

