/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.services;

import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.plugins.providers.DatabaseProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class MySQLDatabaseProvider
extends DatabaseProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "MySQL".equals(database.getDriverType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnection(Database database) {
        Query query = database.createQuery();
        try {
            query.open("select DATABASE() name");
            database.getUserProperties().setProperty("database-name", query.fieldByName("name").getString());
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
    }

    public void beforeDisconnect(Database database) {
    }

    public String getDescription() {
        return stringManager.getString("MySQLDatabaseProvider-description");
    }

    public String getGroupName() {
        return "MySQL";
    }
}

