/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.services;

import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.gui.freezing.FreezeFactory;
import pl.mpak.orbada.mysql.gui.freezing.FreezeViewService;
import pl.mpak.orbada.plugins.IDatabaseObject;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ComponentActionProvider;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class MySQLPerspectiveProvider
extends PerspectiveProvider {
    private final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "MySQL".equals(database.getDriverType());
    }

    public String getDescription() {
        return this.stringManager.getString("MySQLPerspectiveProvider-description");
    }

    public String getGroupName() {
        return "MySQL";
    }

    public void initialize() {
        final JMenu mysql = new JMenu("MySQL");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                mysql.add((Action)((Object)OrbadaMySQLPlugin.findObjectAction));
                ComponentActionProvider[] capa = (ComponentActionProvider[])MySQLPerspectiveProvider.this.application.getServiceArray(ComponentActionProvider.class);
                if (capa != null && capa.length > 0) {
                    boolean first = true;
                    for (ComponentActionProvider cap : capa) {
                        if (!cap.isForComponent(MySQLPerspectiveProvider.this.accesibilities.getDatabase(), "mysql-actions")) continue;
                        cap.setDatabase(MySQLPerspectiveProvider.this.accesibilities.getDatabase());
                        if (first) {
                            mysql.addSeparator();
                        }
                        mysql.add((Action)cap);
                        first = false;
                    }
                }
            }
        });
        this.accesibilities.addMenu(mysql);
        JToolBar toolBar = new JToolBar("MySQL");
        toolBar.add((Component)new ToolButton((Action)((Object)OrbadaMySQLPlugin.findObjectAction)));
        this.accesibilities.addToolBar(toolBar);
    }

    public void processMessage(PluginMessage message) {
        if (this.getAccesibilities() != null && this.getAccesibilities().getDatabase() != null && this.getAccesibilities().getDatabase().getUniqueID().equals(message.getDestinationId()) && message.isMessageId("freeze-object")) {
            final IDatabaseObject object = (IDatabaseObject)message.getObject();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FreezeViewService service = new FreezeFactory().createInstance(object.getObjectType(), StringUtil.nvl((String)object.getSchemaName(), (String)object.getCatalogName()), object.getObjectName());
                    IPerspectiveAccesibilities accessibilities = MySQLPerspectiveProvider.this.application.getActivePerspective();
                    if (service != null && accessibilities != null) {
                        accessibilities.createView((ViewProvider)service);
                    }
                }
            });
            message.setServed(true);
        }
    }
}

