/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.services;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.mysql.OrbadaMySQLPlugin;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.mysql.gui.functions.FunctionParametersPanel;
import pl.mpak.orbada.mysql.gui.procedures.ProcedureParametersPanel;
import pl.mpak.orbada.mysql.gui.tables.TableColumnsPanel;
import pl.mpak.orbada.mysql.gui.views.ViewColumnsPanel;
import pl.mpak.orbada.mysql.services.MySQLDbInfoProvider;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalColumnProvider
extends UniversalActionProvider {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaMySQLPlugin.class);

    public UniversalColumnProvider() {
        this.setText(this.stringManager.getString("UniversalColumnProvider-text"));
        this.setShortCut(117, 2);
        this.setActionCommandKey("UniversalColumnProvider");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "MySQL".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return this.stringManager.getString("UniversalColumnProvider-description");
    }

    public Database getDatabase() {
        return this.accessibilities.getViewAccesibilities().getDatabase();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            private void refreshPanel(final String schema, final String object, final ITabObjectInfo panel) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        panel.refresh(null, schema, object);
                    }
                });
            }

            private void openPanel(String schema, String object, String type) {
                if ("TABLE".equalsIgnoreCase(type)) {
                    TableColumnsPanel panel = new TableColumnsPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                    this.refreshPanel(schema, object, (ITabObjectInfo)panel);
                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.stringManager.getString("columns") + " " + UniversalColumnProvider.this.getDatabase().quoteName(schema, object), (JComponent)((Object)panel));
                } else if ("VIEW".equalsIgnoreCase(type)) {
                    ViewColumnsPanel panel = new ViewColumnsPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                    this.refreshPanel(schema, object, (ITabObjectInfo)panel);
                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.stringManager.getString("columns") + " " + UniversalColumnProvider.this.getDatabase().quoteName(schema, object), (JComponent)((Object)panel));
                } else if ("PROCEDURE".equalsIgnoreCase(type)) {
                    ProcedureParametersPanel panel = new ProcedureParametersPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                    this.refreshPanel(schema, object, (ITabObjectInfo)panel);
                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.stringManager.getString("parameters") + " " + UniversalColumnProvider.this.getDatabase().quoteName(schema, object), (JComponent)((Object)panel));
                } else if ("FUNCTION".equalsIgnoreCase(type)) {
                    FunctionParametersPanel panel = new FunctionParametersPanel(UniversalColumnProvider.this.accessibilities.getViewAccesibilities());
                    this.refreshPanel(schema, object, (ITabObjectInfo)panel);
                    UniversalColumnProvider.this.accessibilities.addResultTab(UniversalColumnProvider.this.stringManager.getString("parameters") + " " + UniversalColumnProvider.this.getDatabase().quoteName(schema, object), (JComponent)((Object)panel));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                block10: {
                    try {
                        String[] words = UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getWordsAt(UniversalColumnProvider.this.accessibilities.getSyntaxEditor().getCaretPosition());
                        String object = null;
                        String schema = MySQLDbInfoProvider.getCurrentDatabase(UniversalColumnProvider.this.getDatabase());
                        if (words == null || words.length <= 0) break block10;
                        if (words.length == 1) {
                            object = words[0];
                        } else {
                            schema = words[0];
                            object = words[1];
                        }
                        Query query = UniversalColumnProvider.this.accessibilities.getViewAccesibilities().getDatabase().createQuery();
                        try {
                            query.setSqlText(Sql.getObjectsType());
                            query.paramByName("SCHEMA_NAME").setString(schema);
                            query.paramByName("OBJECT_NAME").setString(object);
                            query.open();
                            if (!query.eof()) {
                                String type = query.fieldByName("object_type").getString();
                                schema = query.fieldByName("object_schema").getString();
                                object = query.fieldByName("object_name").getString();
                                this.openPanel(schema, object, type);
                            }
                        }
                        catch (Exception ex) {
                            ExceptionUtil.processException((Throwable)ex);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String getGroupName() {
        return "MySQL";
    }
}

