/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.mysql.util;

import java.awt.EventQueue;
import pl.mpak.orbada.core.Application;
import pl.mpak.orbada.gui.comps.AbsOrbadaSyntaxTextArea;
import pl.mpak.orbada.mysql.Sql;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.sky.gui.swing.syntax.SyntaxTextArea;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class SourceCreator {
    private Database database;
    private SyntaxTextArea textArea;

    public SourceCreator(Database database) {
        this.database = database;
    }

    public SourceCreator(Database database, SyntaxTextArea textArea) {
        this(database);
        this.textArea = textArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(final String databaseName, final String objectType, final String objectName) {
        String source;
        PleaseWait wait;
        if (this.textArea != null) {
            wait = PleaseWait.createSqlWait();
            Application.get().startPleaseWait(wait);
        } else {
            wait = null;
        }
        try {
            source = !StringUtil.equals((String)objectName, (String)"") ? ("TRIGGER".equalsIgnoreCase(objectType) ? this.getTrigger(databaseName, objectName) : ("TABLE".equalsIgnoreCase(objectType) ? this.getTable(databaseName, objectName) : ("VIEW".equalsIgnoreCase(objectType) ? this.getView(databaseName, objectName) : ("PROCEDURE".equalsIgnoreCase(objectType) ? this.getProcedure(databaseName, objectName) : ("FUNCTION".equalsIgnoreCase(objectType) ? this.getFunction(databaseName, objectName) : ""))))) : "";
        }
        finally {
            if (wait != null) {
                Application.get().stopPleaseWait(wait);
            }
        }
        if (this.textArea != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (SourceCreator.this.textArea instanceof AbsOrbadaSyntaxTextArea) {
                        ((AbsOrbadaSyntaxTextArea)SourceCreator.this.textArea).setDatabaseObject(databaseName, objectType, objectName, source);
                    }
                    SourceCreator.this.textArea.getEditorArea().setCaretPosition(0);
                }
            });
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTrigger(String databaseName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTriggersSource(databaseName, objectName));
            query.open();
            if (!query.eof()) {
                String string = "DROP TRIGGER " + this.database.quoteName(databaseName, objectName) + "\n/\n" + query.fieldByName("SQL Original Statement").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTable(String databaseName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getTableSource(databaseName, objectName));
            query.open();
            if (!query.eof()) {
                String string = query.fieldByName("Create Table").getString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getView(String databaseName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getViewSource(databaseName, objectName));
            query.open();
            if (!query.eof()) {
                StringBuilder source = new StringBuilder(query.fieldByName("Create View").getString());
                if (StringUtil.charCount((String)source.toString(), (char)'\n') == 0) {
                    int index = SQLUtil.indexOf((String)source.toString(), (String)"create ", (int)0, (boolean)true);
                    if (index == 0) {
                        source.delete(index, "create".length());
                        source.insert(index, "CREATE OR REPLACE");
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)"select ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" from ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n ");
                        index += 3;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" where ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" union ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" and ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n  ");
                        index += 4;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" group by ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)"having ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                    index = 0;
                    while ((index = SQLUtil.indexOf((String)source.toString(), (String)" order by ", (int)index, (boolean)true)) != -1) {
                        source.insert(index, "\n");
                        index += 2;
                    }
                }
                String string = source.toString();
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcedure(String databaseName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getProcedureSource(databaseName, objectName));
            query.open();
            if (!query.eof()) {
                String string = "DROP PROCEDURE IF EXISTS " + this.database.quoteName(databaseName, objectName) + "\n/\n" + query.fieldByName("Create Procedure").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFunction(String databaseName, String objectName) {
        Query query = this.database.createQuery();
        try {
            query.setSqlText(Sql.getFunctionSource(databaseName, objectName));
            query.open();
            if (!query.eof()) {
                String string = "DROP FUNCTION IF EXISTS " + this.database.quoteName(databaseName, objectName) + "\n/\n" + query.fieldByName("Create Function").getString() + "\n/";
                return string;
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        finally {
            query.close();
        }
        return "";
    }
}

