/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.laf.nimrod.gui;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import pl.mpak.orbada.laf.nimrod.OrbadaLafNimRODPlugin;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.ISettingsComponent;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ComboBox;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StreamUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class GlobalOptionsSettingsPanel
extends JPanel
implements ISettingsComponent {
    private StringManager stringManager = StringManagerFactory.getStringManager(OrbadaLafNimRODPlugin.class);
    private IApplication application;
    private File propFile;
    private Properties props;
    private int selectedTheme = -1;
    private String[] themes;
    private ComboBox comboTheme;
    private JLabel jLabel2;

    public GlobalOptionsSettingsPanel(IApplication application) {
        this.application = application;
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.themes = StringUtil.tokenizeList((String)StreamUtil.stream2String((InputStream)OrbadaLafNimRODPlugin.class.getResourceAsStream("/pl/mpak/orbada/laf/nimrod/res/.themes")), (String)"\n");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
        }
        this.comboTheme.setModel(new DefaultComboBoxModel<String>(this.themes));
        this.propFile = new File(this.application.getConfigPath() + "/" + "laf-nimrod.properties");
        this.props = new Properties();
        if (this.propFile.exists()) {
            try {
                this.props.load(new FileInputStream(this.propFile));
            }
            catch (Exception ex) {
                MessageBox.show((Component)this, (String)this.stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)ex);
            }
        }
        this.restoreSettings();
    }

    public void restoreSettings() {
        String currentTheme = this.props.getProperty("current-theme", this.themes[0]);
        for (int i = 0; i < this.themes.length; ++i) {
            if (!this.themes[i].equals(currentTheme)) continue;
            this.comboTheme.setSelectedIndex(i);
            break;
        }
        if (this.comboTheme.getSelectedIndex() == -1) {
            this.comboTheme.setSelectedIndex(0);
        }
    }

    public void applySettings() {
        this.props.setProperty("current-theme", this.themes[this.comboTheme.getSelectedIndex()]);
        try {
            this.props.store(new FileOutputStream(this.propFile), "");
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        if (this.selectedTheme != this.comboTheme.getSelectedIndex() && "nimrod-look-and-feel-service".equals(this.application.getSettings("orbada-settings").getValue("look-and-feel", ""))) {
            this.application.updateLAF();
        }
    }

    public void cancelSettings() {
        this.restoreSettings();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.comboTheme = new ComboBox();
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.stringManager.getString("theme-dd"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.comboTheme, -2, 164, -2).addContainerGap(279, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent((Component)this.comboTheme, -2, -1, -2)).addContainerGap(309, Short.MAX_VALUE)));
    }
}

