/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.laf.nimrod.starters;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalTheme;
import net.sf.nimrod.NimRODLookAndFeel;
import net.sf.nimrod.NimRODTheme;
import pl.mpak.orbada.laf.nimrod.OrbadaLafNimRODPlugin;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.providers.ILookAndFeelStarter;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringUtil;

public class NimRODLookAndFeelStarter
implements ILookAndFeelStarter {
    protected IApplication application;
    protected Properties properties;
    public static final String nimRODConfigFileName = "laf-nimrod.properties";
    public static final String nimRODThemeUrl = "/pl/mpak/orbada/laf/nimrod/res/";
    public static final String set_CurrentTheme = "current-theme";

    public void setApplication(IApplication application) {
        this.application = application;
        this.properties = new Properties();
        File file = new File(application.getConfigPath() + "/" + nimRODConfigFileName);
        if (file.exists()) {
            try {
                this.properties.load(new FileInputStream(file));
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    public void start() throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        NimRODLookAndFeel laf = new NimRODLookAndFeel();
        String theme = this.properties.getProperty(set_CurrentTheme);
        if (!StringUtil.isEmpty((String)theme)) {
            NimRODTheme nt = new NimRODTheme(OrbadaLafNimRODPlugin.class.getResource(nimRODThemeUrl + theme + ".theme"));
            NimRODLookAndFeel.setCurrentTheme((MetalTheme)nt);
        }
        UIManager.setLookAndFeel((LookAndFeel)laf);
    }
}

