/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb;

import java.util.ArrayList;
import java.util.List;
import pl.mpak.orbada.derbydb.services.DerbyDbFunctionsView;
import pl.mpak.orbada.derbydb.services.DerbyDbInfoProvider;
import pl.mpak.orbada.derbydb.services.DerbyDbJarFilesView;
import pl.mpak.orbada.derbydb.services.DerbyDbPerspectiveProvider;
import pl.mpak.orbada.derbydb.services.DerbyDbProceduresView;
import pl.mpak.orbada.derbydb.services.DerbyDbStatisticsService;
import pl.mpak.orbada.derbydb.services.DerbyDbTablesView;
import pl.mpak.orbada.derbydb.services.DerbyDbViewsView;
import pl.mpak.orbada.derbydb.services.UniversalColumnService;
import pl.mpak.orbada.plugins.OrbadaPlugin;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.plugins.spi.IPlugin;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.timer.TimerManager;
import pl.mpak.util.timer.TimerQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrbadaDerbyDbPlugin
extends OrbadaPlugin {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    public static final String apacheDerbyDriverType = "Apache Derby";
    private static TimerQueue refreshQueue;
    public static final ArrayList<Class<? extends IPluginProvider>> classList;

    public static TimerQueue getRefreshQueue() {
        if (refreshQueue == null) {
            refreshQueue = TimerManager.getTimer((String)"orbada-derbydb-refresh");
        }
        return refreshQueue;
    }

    public String getInternalName() {
        return "OrbadaDerbyDbPlugin";
    }

    public String getDescriptiveName() {
        return String.format(stringManager.getString("OrbadaDerbyDbPlugin-descriptive-name"), this.getVersion());
    }

    public String getDescription() {
        return "";
    }

    public String getCategory() {
        return "IDE,Database,Apache Derby DB";
    }

    public String getAuthor() {
        return "Andrzej Ka\u0142u\u017ca";
    }

    public String getCopyrights() {
        return "";
    }

    public String getWebSite() {
        return null;
    }

    public String getUpdateSite() {
        return null;
    }

    public String getVersion() {
        return new VersionID(1, 0, 1, 10).toString();
    }

    public String getLicence() {
        return null;
    }

    public String getUniqueID() {
        return "orbada-derbydb-plugin";
    }

    public void load() {
    }

    public void unload() {
    }

    public void initialize() {
        this.application.registerDriverType(apacheDerbyDriverType);
        classList.add(DerbyDbInfoProvider.class);
        classList.add(DerbyDbTablesView.class);
        classList.add(DerbyDbViewsView.class);
        classList.add(DerbyDbProceduresView.class);
        classList.add(DerbyDbFunctionsView.class);
        classList.add(DerbyDbPerspectiveProvider.class);
        classList.add(DerbyDbJarFilesView.class);
        classList.add(DerbyDbStatisticsService.class);
    }

    public boolean requires(List<IPlugin> list) {
        this.addDepend("orbada-universal-plugin");
        this.addDepend("orbada-commander-plugin");
        for (IPlugin iPlugin : list) {
            if (!"orbada-universal-plugin".equals(iPlugin.getUniqueID())) continue;
            classList.add(UniversalColumnService.class);
        }
        return true;
    }

    public Class<IPluginProvider>[] getProviderArray() {
        return classList.toArray(new Class[classList.size()]);
    }

    public void processMessage(PluginMessage pluginMessage) {
    }

    static {
        classList = new ArrayList();
    }
}

