/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.dbinfo;

import pl.mpak.orbada.derbydb.dbinfo.DerbyDbSchemaListInfo;
import pl.mpak.orbada.derbydb.dbinfo.DerbyDbTableTypeListInfo;
import pl.mpak.orbada.derbydb.dbinfo.DerbyDbTypeListInfo;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectIdentified;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.variant.Variant;

public class DerbyDbDatabaseInfo
extends DbDatabaseInfo {
    public DerbyDbDatabaseInfo(Database database) {
        super(database);
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            ExceptionUtil.processException((Throwable)throwable);
        }
    }

    public String[] getColumnNames() {
        return new String[0];
    }

    public String[] getMemberNames() {
        return new String[]{"Version", "Banner"};
    }

    public Variant[] getMemberValues() {
        return new Variant[]{new Variant(this.getVersion()), new Variant(this.getBanner())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        if (this.isRefreshing()) {
            return;
        }
        this.setRefreshing(true);
        try {
            this.clear();
            this.setVersion(this.getDatabase().getMetaData().getDatabaseProductVersion());
            this.setBanner("Database: " + this.getDatabase().getMetaData().getDatabaseProductName() + ", " + this.getDatabase().getMetaData().getDatabaseProductVersion() + "\n" + "Driver: " + this.getDatabase().getMetaData().getDriverName() + ", " + this.getDatabase().getMetaData().getDriverVersion());
            this.setRemarks(this.getBanner());
            this.put((DbObjectIdentified)new DerbyDbSchemaListInfo(this));
            this.put((DbObjectIdentified)new DerbyDbTableTypeListInfo(this));
            this.put((DbObjectIdentified)new DerbyDbTypeListInfo(this));
        }
        finally {
            this.setRefreshed(true);
        }
    }

    public String getDescription() {
        return "Apache Derby Database Info Provider";
    }
}

