/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.files;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.FileUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.files.FileExtensionFilter;
import pl.mpak.util.variant.Variant;

public class JarFilesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonAddFile;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonRemoveFile;
    private ToolButton buttonSelectSchema;
    private Action cmAddFile;
    private Action cmFilter;
    private Action cmRefreshFiles;
    private Action cmRemoveFile;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private JPanel panelTables;
    private QueryTableStatusBar statusBarTables;
    private ViewTable tableFiles;
    private JToolBar toolBarTables;

    public JarFilesPanelView(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = this.getDatabase().getUserName().toUpperCase();
        this.tableFiles.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = "";
                int n = JarFilesPanelView.this.tableFiles.getSelectedRow();
                if (n >= 0 && JarFilesPanelView.this.tableFiles.getQuery().isActive()) {
                    try {
                        JarFilesPanelView.this.tableFiles.getQuery().getRecord(n);
                        string = JarFilesPanelView.this.tableFiles.getQuery().fieldByName("filename").getString();
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
            }
        });
        this.tableFiles.getQuery().setDatabase(this.getDatabase());
        this.tableFiles.addColumn((TableColumn)new QueryTableColumn("filename", stringManager.getString("JarFilesPanelView-file-name"), 250));
        SqlFilterDef sqlFilterDef = new SqlFilterDef();
        sqlFilterDef.add(new SqlFilterDefComponent("f.filename", stringManager.getString("JarFilesPanelView-file-name"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-files-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableFiles, (JButton)this.buttonActions, this.menuActions, "derbydb-jarfile-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JarFilesPanelView.this.tableFiles.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String string) {
        if (!this.currentSchemaName.equals(string)) {
            this.currentSchemaName = string;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getDatabase().getUserName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String string = null;
            if (this.tableFiles.getQuery().isActive() && this.tableFiles.getSelectedRow() >= 0) {
                this.tableFiles.getQuery().getRecord(this.tableFiles.getSelectedRow());
                string = this.tableFiles.getQuery().fieldByName("FILENAME").getString();
            }
            this.refresh(string);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string) {
        try {
            int n = Math.max(0, this.tableFiles.getSelectedRow());
            this.tableFiles.getQuery().close();
            this.tableFiles.getQuery().setSqlText(DerbyDbSql.getFileList(this.filter.getSqlText()));
            this.tableFiles.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableFiles.getQuery().open();
            if (string != null && this.tableFiles.getQuery().locate("FILENAME", new Variant(string))) {
                this.tableFiles.changeSelection(this.tableFiles.getQuery().getCurrentRecord().getIndex(), this.tableFiles.getSelectedColumn());
            } else if (!this.tableFiles.getQuery().isEmpty()) {
                this.tableFiles.changeSelection(Math.min(n, this.tableFiles.getRowCount() - 1), this.tableFiles.getSelectedColumn());
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        this.tableFiles.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefreshFiles = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmRemoveFile = new Action();
        this.cmAddFile = new Action();
        this.menuActions = new JPopupMenu();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableFiles = new ViewTable();
        this.statusBarTables = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonAddFile = new ToolButton();
        this.buttonRemoveFile = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefreshFiles.setActionCommandKey("cmRefreshFiles");
        this.cmRefreshFiles.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefreshFiles.setText(stringManager.getString("JarFilesPanelView-cmRefreshFiles-text"));
        this.cmRefreshFiles.setTooltip(stringManager.getString("JarFilesPanelView-cmRefreshFiles-hint"));
        this.cmRefreshFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarFilesPanelView.this.cmRefreshFilesActionPerformed(actionEvent);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarFilesPanelView.this.cmSelectSchemaActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarFilesPanelView.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmRemoveFile.setActionCommandKey("cmRemoveFile");
        this.cmRemoveFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmRemoveFile.setText(stringManager.getString("JarFilesPanelView-cmRemoveFile-text"));
        this.cmRemoveFile.setTooltip(stringManager.getString("JarFilesPanelView-cmRemoveFile-hint"));
        this.cmRemoveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarFilesPanelView.this.cmRemoveFileActionPerformed(actionEvent);
            }
        });
        this.cmAddFile.setActionCommandKey("cmAddFile");
        this.cmAddFile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/new_package.gif"));
        this.cmAddFile.setText(stringManager.getString("JarFilesPanelView-cmAddFile-text"));
        this.cmAddFile.setTooltip(stringManager.getString("JarFilesPanelView-cmAddFile-hint"));
        this.cmAddFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarFilesPanelView.this.cmAddFileActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                JarFilesPanelView.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableFiles);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableFiles);
        this.panelTables.add((Component)this.statusBarTables, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefreshFiles);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonAddFile.setAction((javax.swing.Action)this.cmAddFile);
        this.buttonAddFile.setHorizontalTextPosition(0);
        this.buttonAddFile.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonAddFile);
        this.buttonRemoveFile.setAction((javax.swing.Action)this.cmRemoveFile);
        this.buttonRemoveFile.setHorizontalTextPosition(0);
        this.buttonRemoveFile.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRemoveFile);
        this.toolBarTables.add(this.jSeparator2);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.add((Component)this.panelTables, "Center");
    }

    private void cmRemoveFileActionPerformed(ActionEvent actionEvent) {
        if (this.tableFiles.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableFiles.getQuery().getRecord(this.tableFiles.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableFiles.getQuery().fieldByName("filename").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)stringManager.getString("JarFilesPanelView-delete-jar-file-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                    this.getDatabase().createCommand("call sqlj.remove_jar('" + string + "', 1)", true);
                    this.refresh(null);
                }
            }
            catch (Exception exception) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)exception.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        if (!this.tableFiles.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent actionEvent) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open("select schemaname from sys.sysschemas order by schemaname");
            Vector vector = QueryUtil.staticData((String)"{schemaname}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vector, (int)vector.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object object) {
                    JarFilesPanelView.this.setCurrentSchemaName(object.toString());
                    JarFilesPanelView.this.refresh();
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshFilesActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private void cmAddFileActionPerformed(ActionEvent actionEvent) {
        String string;
        File file = FileUtil.selectFileToOpen((Component)this, (FileExtensionFilter[])new FileExtensionFilter[]{new FileExtensionFilter(stringManager.getString("JarFilesPanelView-jar-library"), new String[]{".jar"})});
        if (file != null && (string = JOptionPane.showInputDialog(this, stringManager.getString("JarFilesPanelView-input-jar-name-dd"), file.getName().replace('.', '_'))) != null) {
            try {
                this.getDatabase().createCommand("call sqlj.install_jar('" + file.getPath() + "', '" + string + "', 1)", true);
                this.refresh(null);
            }
            catch (Exception exception) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)exception.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }
}

