/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.parser.SQLTokenHandle;
import pl.mpak.util.parser.TokenHandle;
import pl.mpak.util.parser.Tokenizer;
import pl.mpak.util.timer.Timer;

public class ParametersPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentProcName = "";
    private boolean requestRefresh = false;
    private Timer timer;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JScrollPane jScrollPane1;
    private QueryTableStatusBar statusBarParams;
    private ViewTable tableParams;
    private JToolBar toolBarParams;

    public ParametersPanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                try {
                    ParametersPanel.this.requestRefresh = false;
                    ParametersPanel.this.tableParams.getQuery().close();
                    String string = ParametersPanel.this.sourceToSqlText();
                    if (string != null) {
                        ParametersPanel.this.tableParams.getQuery().setSqlText(ParametersPanel.this.sourceToSqlText());
                        ParametersPanel.this.tableParams.getQuery().open();
                        if (!ParametersPanel.this.tableParams.getQuery().isEmpty()) {
                            ParametersPanel.this.tableParams.changeSelection(0, 0);
                        }
                    }
                }
                catch (Exception exception) {
                    ExceptionUtil.processException((Throwable)exception);
                }
            }
        };
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        this.tableParams.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = ParametersPanel.this.tableParams.getSelectedRow();
                if (n >= 0 && ParametersPanel.this.tableParams.getQuery().isActive()) {
                    try {
                        ParametersPanel.this.tableParams.getQuery().getRecord(n);
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
            }
        });
        this.tableParams.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableParams.addColumn((TableColumn)new QueryTableColumn("name", stringManager.getString("ParametersPanel-parameter-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableParams.addColumn((TableColumn)new QueryTableColumn("type", stringManager.getString("ParametersPanel-parameter-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableParams.addColumn((TableColumn)new QueryTableColumn("method", stringManager.getString("ParametersPanel-parameter-method"), 60));
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private String sourceToSqlText(String string) {
        try {
            String string2;
            String string3;
            String string4;
            Tokenizer tokenizer = new Tokenizer(string, (TokenHandle)new SQLTokenHandle());
            StringBuffer stringBuffer = new StringBuffer();
            while (!tokenizer.isEof()) {
                tokenizer.getNextToken();
                if (!"(".equals(tokenizer.getString())) continue;
            }
            boolean bl = false;
            tokenizer.getNextToken(1);
            while (!tokenizer.isEof() && !")".equals(string4 = tokenizer.getString())) {
                if (",".equals(string4)) {
                    tokenizer.getNextToken(1);
                    string4 = tokenizer.getString();
                }
                bl = true;
                string3 = "IN";
                string2 = "";
                String string5 = "";
                if ("IN".equalsIgnoreCase(string4) || "OUT".equalsIgnoreCase(string4) || "INOUT".equalsIgnoreCase(string4)) {
                    string3 = string4;
                    tokenizer.getNextToken(1);
                    string4 = tokenizer.getString();
                }
                string2 = string4;
                tokenizer.getNextToken(1);
                string5 = tokenizer.getString();
                tokenizer.getNextToken(1);
                string4 = tokenizer.getString();
                if ("(".equals(string4)) {
                    tokenizer.getNextToken(1);
                    string5 = string5 + "(" + tokenizer.getString();
                    tokenizer.getNextToken(1);
                    string4 = tokenizer.getString();
                    if (",".equals(string4)) {
                        tokenizer.getNextToken(1);
                        string5 = string5 + "," + tokenizer.getString();
                        tokenizer.getNextToken(1);
                    }
                    tokenizer.getNextToken(1);
                    string5 = string5 + ")";
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",\n        ");
                }
                stringBuffer.append("('" + string2 + "', '" + string5 + "', '" + string3 + "')");
            }
            tokenizer.getNextToken(1);
            if ("RETURNS".equalsIgnoreCase(tokenizer.getString())) {
                bl = true;
                string4 = "{RETURNS}";
                tokenizer.getNextToken(1);
                string3 = tokenizer.getString();
                tokenizer.getNextToken(1);
                if ("(".equals(tokenizer.getString())) {
                    tokenizer.getNextToken(1);
                    string3 = string3 + "(" + tokenizer.getString();
                    tokenizer.getNextToken(1);
                    string2 = tokenizer.getString();
                    if (",".equals(string2)) {
                        tokenizer.getNextToken(1);
                        string3 = string3 + "," + tokenizer.getString();
                        tokenizer.getNextToken(1);
                    }
                    tokenizer.getNextToken(1);
                    string3 = string3 + ")";
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",\n        ");
                }
                stringBuffer.append("('" + string4 + "', '" + string3 + "', 'OUT')");
            } else {
                while (!tokenizer.isEof()) {
                    tokenizer.getNextToken(1);
                    if (!"RESULT".equalsIgnoreCase(tokenizer.getString())) continue;
                    tokenizer.getNextToken(1);
                    if (!"SETS".equalsIgnoreCase(tokenizer.getString())) continue;
                    bl = true;
                    tokenizer.getNextToken(1);
                    string4 = tokenizer.getString();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",\n        ");
                    }
                    stringBuffer.append("('{RETURNS}', 'RESULT SET (" + string4 + ")', 'OUT')");
                    break;
                }
            }
            if (!bl) {
                stringBuffer.append("('', '', '')");
            }
            stringBuffer.insert(0, "select *\n  from (values");
            stringBuffer.append(") x(name, type, method)");
            if (!bl) {
                stringBuffer.append("\n where 1 = 0");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sourceToSqlText() {
        Query query = this.getDatabase().createQuery();
        try {
            query.setSqlText(DerbyDbSql.getProcedureSource());
            query.paramByName("schemaname").setString(this.currentSchemaName);
            query.paramByName("procname").setString(this.currentProcName);
            query.open();
            if (!query.eof()) {
                String string = this.sourceToSqlText(query.fieldByName("source").getString());
                return string;
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            query.close();
        }
        return null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("ParametersPanel-title");
    }

    public void refresh() {
        this.refresh(null, this.currentSchemaName, this.currentProcName);
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentProcName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentProcName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableParams.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.jScrollPane1 = new JScrollPane();
        this.tableParams = new ViewTable();
        this.statusBarParams = new QueryTableStatusBar();
        this.toolBarParams = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ParametersPanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableParams);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarParams.setShowFieldType(false);
        this.statusBarParams.setShowOpenTime(false);
        this.statusBarParams.setTable((QueryTable)this.tableParams);
        this.add((Component)this.statusBarParams, "Last");
        this.toolBarParams.setFloatable(false);
        this.toolBarParams.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarParams.add((Component)this.buttonRefresh);
        this.add((Component)this.toolBarParams, "First");
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentProcName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.timer.restart();
    }
}

