/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class ProcedureSourcePanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentProcName = "";
    private boolean requestRefresh = false;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonRefresh;
    private Action cmRefresh;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea syntaxProcSource;
    private JToolBar toolBarContent;

    public ProcedureSourcePanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProcedureSourcePanel.this.syntaxProcSource.setText(string);
                ProcedureSourcePanel.this.syntaxProcSource.getEditorArea().setCaretPosition(0);
            }
        });
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setEnabled(false);
                ProcedureSourcePanel.this.requestRefresh = false;
                Query query = ProcedureSourcePanel.this.getDatabase().createQuery();
                try {
                    query.setSqlText(DerbyDbSql.getProcedureSource());
                    query.paramByName("schemaname").setString(ProcedureSourcePanel.this.currentSchemaName);
                    query.paramByName("procname").setString(ProcedureSourcePanel.this.currentProcName);
                    query.open();
                    if (!query.eof()) {
                        ProcedureSourcePanel.this.setEditorText(query.fieldByName("source").getString());
                    } else {
                        ProcedureSourcePanel.this.setEditorText("");
                    }
                }
                catch (Exception exception) {
                    ExceptionUtil.processException((Throwable)exception);
                }
                finally {
                    query.close();
                }
            }
        };
        this.syntaxProcSource.setDatabase(this.getDatabase());
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.syntaxProcSource.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "derbydb-object-source-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("ProcedureSourcePanel-title");
    }

    public void refresh() {
        this.refresh(null, this.currentSchemaName, this.currentProcName);
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentProcName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentProcName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
                this.setEditorText("");
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.syntaxProcSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.menuActions = new JPopupMenu();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.syntaxProcSource = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("ProcedureSourcePanel-cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProcedureSourcePanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ProcedureSourcePanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.toolBarContent.add(this.jSeparator1);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonActions);
        this.add((Component)this.toolBarContent, "First");
        this.add((Component)this.syntaxProcSource, "Center");
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentProcName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.timer.restart();
    }
}

