/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.procedures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.procedures.ParametersPanel;
import pl.mpak.orbada.derbydb.procedures.ProcedureSourcePanel;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ProceduresPanelView
extends JPanel
implements IRootTabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private JPanel panelViews;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBarViews;
    private JTabbedPane tabbedViewInfo;
    private ViewTable tableProcs;
    private JToolBar toolBarViews;

    public ProceduresPanelView(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = this.getDatabase().getUserName().toUpperCase();
        this.tableProcs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = "";
                int n = ProceduresPanelView.this.tableProcs.getSelectedRow();
                if (n >= 0 && ProceduresPanelView.this.tableProcs.getQuery().isActive()) {
                    try {
                        ProceduresPanelView.this.tableProcs.getQuery().getRecord(n);
                        string = ProceduresPanelView.this.tableProcs.getQuery().fieldByName("alias").getString();
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
                for (int i = 0; i < ProceduresPanelView.this.tabbedViewInfo.getTabCount(); ++i) {
                    Component component = ProceduresPanelView.this.tabbedViewInfo.getComponentAt(i);
                    if (!(component instanceof ITabObjectInfo)) continue;
                    ((ITabObjectInfo)component).refresh(null, ProceduresPanelView.this.currentSchemaName, string);
                }
            }
        });
        this.addInfoPanel(stringManager.getString("ProceduresPanelView-parameters"), new ParametersPanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("ProceduresPanelView-source"), new ProcedureSourcePanel(this.accesibilities));
        this.tableProcs.getQuery().setDatabase(this.getDatabase());
        this.tableProcs.addColumn((TableColumn)new QueryTableColumn("alias", stringManager.getString("ProceduresPanelView-procedure-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableProcs.addColumn((TableColumn)new QueryTableColumn("javaclassname", stringManager.getString("ProceduresPanelView-class-name"), 250));
        SqlFilterDef sqlFilterDef = new SqlFilterDef();
        sqlFilterDef.add(new SqlFilterDefComponent("a.alias", stringManager.getString("ProceduresPanelView-procedure-name"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-procedures-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableProcs, (JButton)this.buttonActions, this.menuActions, "derbydb-procedures-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ProceduresPanelView.this.tableProcs.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String string) {
        if (!this.currentSchemaName.equals(string)) {
            this.currentSchemaName = string;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getDatabase().getUserName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String string = null;
            if (this.tableProcs.getQuery().isActive() && this.tableProcs.getSelectedRow() >= 0) {
                this.tableProcs.getQuery().getRecord(this.tableProcs.getSelectedRow());
                string = this.tableProcs.getQuery().fieldByName("alias").getString();
            }
            this.refresh(string);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string) {
        try {
            this.tableProcs.getQuery().close();
            this.tableProcs.getQuery().setSqlText(DerbyDbSql.getProcedureList(this.filter.getSqlText()));
            this.tableProcs.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableProcs.getQuery().paramByName("aliastype").setString("P");
            this.tableProcs.getQuery().open();
            if (string != null && this.tableProcs.getQuery().locate("alias", new Variant(string))) {
                this.tableProcs.changeSelection(this.tableProcs.getQuery().getCurrentRecord().getIndex(), this.tableProcs.getSelectedColumn());
            } else if (!this.tableProcs.getQuery().isEmpty()) {
                this.tableProcs.changeSelection(0, this.tableProcs.getSelectedColumn());
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void addInfoPanel(String string, JPanel jPanel) {
        this.tabbedViewInfo.addTab(string, jPanel);
        this.tabbedViewInfo.setTabComponentAt(this.tabbedViewInfo.indexOfComponent(jPanel), (Component)new TabCloseComponent(string));
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        int n = 0;
        while (n < this.tabbedViewInfo.getTabCount()) {
            Component component = this.tabbedViewInfo.getComponentAt(n);
            if (component instanceof Closeable) {
                try {
                    ((Closeable)((Object)component)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++n;
            }
            this.tabbedViewInfo.remove(component);
        }
        this.tableProcs.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.menuActions = new JPopupMenu();
        this.splinPane = new JSplitPane();
        this.panelViews = new JPanel();
        this.toolBarViews = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableProcs = new ViewTable();
        this.statusBarViews = new QueryTableStatusBar();
        this.tabbedViewInfo = new JTabbedPane();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProceduresPanelView.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProceduresPanelView.this.cmSelectSchemaActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProceduresPanelView.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ProceduresPanelView.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(250);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelViews.setPreferredSize(new Dimension(250, 100));
        this.panelViews.setLayout(new BorderLayout());
        this.toolBarViews.setFloatable(false);
        this.toolBarViews.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonFilter);
        this.toolBarViews.add(this.jSeparator1);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonActions);
        this.panelViews.add((Component)this.toolBarViews, "First");
        this.jScrollPane1.setViewportView((Component)this.tableProcs);
        this.panelViews.add((Component)this.jScrollPane1, "Center");
        this.statusBarViews.setShowFieldType(false);
        this.statusBarViews.setShowFieldValue(false);
        this.statusBarViews.setShowOpenTime(false);
        this.statusBarViews.setTable((QueryTable)this.tableProcs);
        this.panelViews.add((Component)this.statusBarViews, "Last");
        this.splinPane.setLeftComponent(this.panelViews);
        this.tabbedViewInfo.setFocusable(false);
        this.splinPane.setRightComponent(this.tabbedViewInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        if (!this.tableProcs.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent actionEvent) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open("select schemaname from sys.sysschemas order by schemaname");
            Vector vector = QueryUtil.staticData((String)"{schemaname}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vector, (int)vector.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object object) {
                    ProceduresPanelView.this.setCurrentSchemaName(object.toString());
                    ProceduresPanelView.this.refresh();
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

