/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.services;

import java.awt.Component;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.dbinfo.DerbyDbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbDatabaseInfo;
import pl.mpak.orbada.plugins.dbinfo.DbObjectContainer;
import pl.mpak.orbada.plugins.providers.DatabaseInfoProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.DatabaseListener;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;

public class DerbyDbInfoProvider
extends DatabaseInfoProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    public static DerbyDbInfoProvider instance;
    private HashMap<String, DbDatabaseInfo> databaseInfoList;

    public DerbyDbInfoProvider() {
        instance = this;
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Apache Derby".equals(database.getDriverType());
    }

    private String getUniqueName(Database database) {
        return database.getUniqueID();
    }

    public void resetDatabaseInfo(Database database) {
        this.databaseInfoList.remove(this.getUniqueName(database));
    }

    public String[] getKeywords(Database database) {
        try {
            String[] stringArray = new String[]{"ALLOCATE", "ALTER", "ANY", "ARE", "ASC", "ASSERTION", "ADD", "AT", "AUTHORIZATION", "BEGIN", "BIT", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DROP", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INDEX", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEFT", "MATCH", "NATIONAL", "NATURAL", "NEXT", "NO", "NULL", "OF", "ON", "ONLY", "OPEN", "OPTION", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "USING", "VALUES", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WHEN", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "TRIGGER", "AFTER", "BEFORE", "REFERENCING", "EACH", "ROW", "MODE", "DB2SQL", "THEN", "OUT", "LANGUAGE", "JAVA", "PARAMETER", "STYLE", "READS", "NAME", "RESULT", "SETS", "DYNAMIC", "AS", "AND", "OR"};
            StringUtil.unionList((String[])stringArray, (String[])StringUtil.tokenizeList((String)database.getMetaData().getSQLKeywords(), (String)", "));
            return stringArray;
        }
        catch (SQLException sQLException) {
            ExceptionUtil.processException((Throwable)sQLException);
            return null;
        }
    }

    public String[] getOperators(Database database) {
        String[] stringArray = new String[]{"ALL", "ANY", "BETWEEN", "IN", "IS", "LIKE", "NOT", "EXISTS"};
        return stringArray;
    }

    public String[] getContainerList(DbObjectContainer dbObjectContainer) {
        if (dbObjectContainer != null) {
            return dbObjectContainer.namesArray();
        }
        return new String[0];
    }

    public String[] getUserTables(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + database.getUserName().toUpperCase() + "/TABLES"));
        String[] stringArray2 = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + database.getUserName().toUpperCase() + "/VIEWS"));
        return StringUtil.unionList((String[])stringArray, (String[])stringArray2);
    }

    public String[] getExceptions(Database database) {
        return null;
    }

    public String[] getSqlFunctions(Database database) {
        try {
            String[] stringArray = new String[]{"AVG", "ABS", "ABSVAL", "ACOS", "ASIN", "ATAN", "CAST", "CEIL", "CEILING", "COUNT", "COS", "NULLIF", "CASE", "CURRENT_DATE", "CURRENT", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DATE", "DAY", "DEGREES", "DOUBLE", "EXP", "FLOOR", "HOUR", "IDENTITY_VAL_LOCAL", "LENGTH", "LN", "LOG", "LOG10", "LOCATE", "LCASE", "LOWER", "LTRIM", "MINUTE", "MOD", "MONTH", "PI", "RADIANS", "RTRIM", "SECOND", "SESSION_USER", "SIN", "SMALLINT", "SQRT", "SUBSTR", "TAN", "UCASE", "UPPER", "USER", "YEAR", "MAX", "MIN"};
            StringUtil.unionList((String[])stringArray, (String[])StringUtil.tokenizeList((String)database.getMetaData().getStringFunctions(), (String)", "));
            StringUtil.unionList((String[])stringArray, (String[])StringUtil.tokenizeList((String)database.getMetaData().getTimeDateFunctions(), (String)", "));
            StringUtil.unionList((String[])stringArray, (String[])StringUtil.tokenizeList((String)database.getMetaData().getNumericFunctions(), (String)", "));
            StringUtil.unionList((String[])stringArray, (String[])StringUtil.tokenizeList((String)database.getMetaData().getSystemFunctions(), (String)", "));
            return stringArray;
        }
        catch (SQLException sQLException) {
            ExceptionUtil.processException((Throwable)sQLException);
            return null;
        }
    }

    public String[] getUserFunctions(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + database.getUserName().toUpperCase() + "/PROCEDURES"));
        String[] stringArray2 = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/" + database.getUserName().toUpperCase() + "/FUNCTIONS"));
        return StringUtil.unionList((String[])stringArray, (String[])stringArray2);
    }

    public String[] getPublicTables(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/SYS/TABLES"));
        String[] stringArray2 = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS/SYS/VIEWS"));
        return StringUtil.unionList((String[])stringArray, (String[])stringArray2);
    }

    public String[] getDataTypes(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/TYPES"));
        return stringArray;
    }

    public String[] getSchemas(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/SCHEMAS"));
        return stringArray;
    }

    public String[] getTableTypes(Database database) {
        String[] stringArray = this.getContainerList((DbObjectContainer)this.getDatabaseInfo(database).getObjectInfo("/TABLE TYPES"));
        return stringArray;
    }

    public Component[] getExtendedPanelInfo(Database database) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbDatabaseInfo getDatabaseInfo(final Database database) {
        DerbyDbInfoProvider derbyDbInfoProvider = this;
        synchronized (derbyDbInfoProvider) {
            DbDatabaseInfo dbDatabaseInfo;
            if (this.databaseInfoList == null) {
                this.databaseInfoList = new HashMap();
            }
            if ((dbDatabaseInfo = this.databaseInfoList.get(this.getUniqueName(database))) == null) {
                dbDatabaseInfo = new DerbyDbDatabaseInfo(database);
                this.databaseInfoList.put(this.getUniqueName(database), dbDatabaseInfo);
                database.addDatabaseListener(new DatabaseListener(){

                    public void beforeConnect(EventObject eventObject) {
                    }

                    public void afterConnect(EventObject eventObject) {
                    }

                    public void beforeDisconnect(EventObject eventObject) {
                    }

                    public void afterDisconnect(EventObject eventObject) {
                        DerbyDbInfoProvider.this.databaseInfoList.remove(DerbyDbInfoProvider.this.getUniqueName(database));
                    }
                });
            }
            return dbDatabaseInfo;
        }
    }

    public String getDescription() {
        return stringManager.getString("DerbyDbInfoProvider-description");
    }

    public String getGroupName() {
        return "Apache Derby";
    }
}

