/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.services;

import javax.swing.Action;
import javax.swing.JMenu;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.cm.CreateConstraintCheckWizardAction;
import pl.mpak.orbada.derbydb.cm.CreateConstraintForeignKeyAction;
import pl.mpak.orbada.derbydb.cm.CreateConstraintPrimaryKeyAction;
import pl.mpak.orbada.derbydb.cm.CreateIndexWizardAction;
import pl.mpak.orbada.derbydb.cm.DerbyDbSearchObjectAction;
import pl.mpak.orbada.plugins.providers.PerspectiveProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DerbyDbPerspectiveProvider
extends PerspectiveProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Apache Derby".equals(database.getDriverType());
    }

    public String getDescription() {
        return String.format(stringManager.getString("DerbyDbPerspectiveProvider-description"), "Apache Derby");
    }

    public String getGroupName() {
        return "Apache Derby";
    }

    public void initialize() {
        DerbyDbSearchObjectAction derbyDbSearchObjectAction = new DerbyDbSearchObjectAction(this.accesibilities);
        JMenu jMenu = new JMenu("Apache Derby");
        jMenu.add((Action)((Object)derbyDbSearchObjectAction));
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu(stringManager.getString("DerbyDbPerspectiveProvider-wizzards"));
        jMenu2.add((Action)((Object)new CreateIndexWizardAction(this.accesibilities.getDatabase())));
        jMenu2.add((Action)((Object)new CreateConstraintCheckWizardAction(this.accesibilities.getDatabase())));
        jMenu2.add((Action)((Object)new CreateConstraintForeignKeyAction(this.accesibilities.getDatabase())));
        jMenu2.add((Action)((Object)new CreateConstraintPrimaryKeyAction(this.accesibilities.getDatabase())));
        jMenu.add(jMenu2);
        this.accesibilities.addMenu(jMenu);
        this.accesibilities.addAction((pl.mpak.sky.gui.swing.Action)derbyDbSearchObjectAction);
    }
}

