/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.services;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.universal.StatisticsPanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DerbyDbStatisticsService
extends UniversalActionProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);

    public DerbyDbStatisticsService() {
        this.setShortCut(84, 2);
        this.setText(stringManager.getString("DerbyDbStatisticsService-text"));
        this.setTooltip("<html>" + this.getText() + "<br>\n" + stringManager.getString("DerbyDbStatisticsService-hint"));
        this.setSmallIcon(ImageManager.getImage((String)"/pl/mpak/res/icons/autotrace.gif"));
        this.setActionCommandKey("cmDerbyDbStatisticsService");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Apache Derby".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return true;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return "Apache Derby " + this.getText();
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyDbStatisticsService.this.openResultTab();
            }
        };
    }

    private void openResultTab() {
        Component[] componentArray = this.accessibilities.getResultTabs(StatisticsPanel.class);
        if (componentArray.length > 0) {
            StatisticsPanel statisticsPanel = (StatisticsPanel)componentArray[0];
            this.accessibilities.setSelectedTab((Component)statisticsPanel);
        } else {
            StatisticsPanel statisticsPanel = new StatisticsPanel(this.accessibilities.getViewAccesibilities().getDatabase());
            statisticsPanel.afterSql();
            this.accessibilities.addResultTab(this.getText(), (JComponent)statisticsPanel);
        }
    }

    private void beforeSql() {
        Component[] componentArray = this.accessibilities.getResultTabs(StatisticsPanel.class);
        if (componentArray.length > 0) {
            StatisticsPanel statisticsPanel = (StatisticsPanel)componentArray[0];
            statisticsPanel.beforeSql();
        }
    }

    private void afterSql() {
        Component[] componentArray = this.accessibilities.getResultTabs(StatisticsPanel.class);
        if (componentArray.length > 0) {
            StatisticsPanel statisticsPanel = (StatisticsPanel)componentArray[0];
            statisticsPanel.afterSql();
        }
    }

    public void beforeOpenQuery(Query query) {
        this.beforeSql();
    }

    public void afterOpenQuery(Query query) {
        this.afterSql();
    }

    public void beforeExecuteCommand(Command command) {
        this.beforeSql();
    }

    public void afterExecuteCommand(Command command) {
        this.afterSql();
    }

    public String getGroupName() {
        return "Apache Derby";
    }
}

