/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.services;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.procedures.ParametersPanel;
import pl.mpak.orbada.derbydb.tables.TableColumnsPanel;
import pl.mpak.orbada.universal.providers.UniversalActionProvider;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class UniversalColumnService
extends UniversalActionProvider {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);

    public UniversalColumnService() {
        this.setText(stringManager.getString("UniversalColumnService-text"));
        this.setShortCut(117, 2);
        this.setActionCommandKey("cmUniversalColumnService");
        this.addActionListener(this.createActionListener());
    }

    public boolean isForDatabase(Database database) {
        if (database == null) {
            return false;
        }
        return "Apache Derby".equals(database.getDriverType());
    }

    public boolean addToolButton() {
        return false;
    }

    public boolean addMenuItem() {
        return true;
    }

    public boolean addToEditor() {
        return true;
    }

    public String getDescription() {
        return stringManager.getString("UniversalColumnService-description");
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                block13: {
                    try {
                        String[] stringArray = UniversalColumnService.this.accessibilities.getSyntaxEditor().getWordsAt(UniversalColumnService.this.accessibilities.getSyntaxEditor().getCaretPosition());
                        String string = null;
                        String string2 = UniversalColumnService.this.accessibilities.getViewAccesibilities().getDatabase().getUserName().toUpperCase();
                        if (stringArray == null || stringArray.length <= 0) break block13;
                        if (stringArray.length == 1) {
                            string = stringArray[0];
                        } else {
                            string2 = stringArray[0];
                            string = stringArray[1];
                        }
                        Query query = UniversalColumnService.this.accessibilities.getViewAccesibilities().getDatabase().createQuery();
                        try {
                            query.setSqlText(DerbyDbSql.getObjectType());
                            query.paramByName("schemaname").setString(string2);
                            query.paramByName("objectname").setString(string);
                            query.open();
                            if (!query.eof()) {
                                String string3 = query.fieldByName("objecttype").getString();
                                if ("PROCEDURE".equalsIgnoreCase(string3) || "FUNCTION".equalsIgnoreCase(string3)) {
                                    UniversalColumnService.this.setText("Parametry");
                                    ParametersPanel parametersPanel = new ParametersPanel(UniversalColumnService.this.accessibilities.getViewAccesibilities());
                                    parametersPanel.refresh(null, string2, string);
                                    UniversalColumnService.this.accessibilities.addResultTab(UniversalColumnService.this.getText() + " \"" + string2 + "\".\"" + string + "\"", (JComponent)parametersPanel);
                                } else if ("TABLE".equalsIgnoreCase(string3) || "VIEW".equalsIgnoreCase(string3)) {
                                    UniversalColumnService.this.setText("Kolumny");
                                    TableColumnsPanel tableColumnsPanel = new TableColumnsPanel(UniversalColumnService.this.accessibilities.getViewAccesibilities(), "VIEW".equalsIgnoreCase(string3));
                                    tableColumnsPanel.refresh(null, string2, string);
                                    UniversalColumnService.this.accessibilities.addResultTab(UniversalColumnService.this.getText() + " \"" + string2 + "\".\"" + string + "\"", (JComponent)tableColumnsPanel);
                                }
                            }
                        }
                        catch (Exception exception) {
                            ExceptionUtil.processException((Throwable)exception);
                        }
                        finally {
                            query.close();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String getGroupName() {
        return "Apache Derby";
    }
}

