/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.AlterTableNullWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;
import pl.mpak.util.variant.Variant;

public class TableColumnsPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean isView;
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonColumnNotNull;
    private ToolButton buttonCreateConstraintCheck;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmColumnNotNull;
    private Action cmCreateConstraintCheck;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarColumns;
    private ViewTable tableColumns;
    private JToolBar toolBarColumns;

    public TableColumnsPanel(IViewAccesibilities iViewAccesibilities) {
        this(iViewAccesibilities, false);
    }

    public TableColumnsPanel(IViewAccesibilities iViewAccesibilities, boolean bl) {
        this.accesibilities = iViewAccesibilities;
        this.isView = bl;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableColumnsPanel.this.refresh();
            }
        };
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        this.tableColumns.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableColumnsPanel.this.tableColumns.getSelectedRow();
                if (n >= 0 && TableColumnsPanel.this.tableColumns.getQuery().isActive()) {
                    try {
                        TableColumnsPanel.this.tableColumns.getQuery().getRecord(n);
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
            }
        });
        this.tableColumns.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("columnnumber", stringManager.getString("TableColumnsPanel-lp"), 30));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("columnname", stringManager.getString("TableColumnsPanel-column-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableColumns.addColumn((TableColumn)new QueryTableColumn("columndatatype", stringManager.getString("TableColumnsPanel-column-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            if (!this.isView) {
                this.tableColumns.addColumn((TableColumn)new QueryTableColumn("columndefault", stringManager.getString("TableColumnsPanel-default-value"), 300));
                this.tableColumns.addColumn((TableColumn)new QueryTableColumn("autoincrementvalue", stringManager.getString("TableColumnsPanel-autoinc-value"), 30));
                this.tableColumns.addColumn((TableColumn)new QueryTableColumn("autoincrementstart", stringManager.getString("TableColumnsPanel-autoinc-start"), 30));
                this.tableColumns.addColumn((TableColumn)new QueryTableColumn("autoincrementinc", stringManager.getString("TableColumnsPanel-autoinc-next"), 30));
            }
            SqlFilterDef sqlFilterDef = new SqlFilterDef();
            sqlFilterDef.add(new SqlFilterDefComponent("c.columnname", stringManager.getString("TableColumnsPanel-column-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("varchar( c.columndatatype, 512 )", stringManager.getString("TableColumnsPanel-column-type"), new String[]{"", "'VARCHAR%'", "'NUMERIC%'", "'INTEGER%'", "'TIMESTAMP%'"}));
            sqlFilterDef.add(new SqlFilterDefComponent("varchar( c.columndefault, 512 )", stringManager.getString("TableColumnsPanel-default-value"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("c.autoincrementvalue is not null", stringManager.getString("TableColumnsPanel-autoincremental")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-" + (this.isView ? "view" : "table") + "-columns-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableColumns, (JButton)this.buttonActions, this.menuActions, "derbydb-table-columns-actions");
        if (this.isView) {
            this.cmColumnNotNull.setEnabled(false);
            this.cmCreateConstraintCheck.setEnabled(false);
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("TableColumnsPanel-title");
    }

    public void refresh() {
        try {
            String string = null;
            this.requestRefresh = false;
            if (this.tableColumns.getQuery().isActive() && this.tableColumns.getSelectedRow() >= 0) {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                string = this.tableColumns.getQuery().fieldByName("COLUMNNAME").getString();
            }
            this.tableColumns.getQuery().close();
            this.tableColumns.getQuery().setSqlText(DerbyDbSql.getTableColumnList(this.filter.getSqlText()));
            this.tableColumns.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableColumns.getQuery().paramByName("tablename").setString(this.currentTableName);
            this.tableColumns.getQuery().open();
            if (!this.tableColumns.getQuery().isEmpty()) {
                if (string != null && this.tableColumns.getQuery().locate("columnname", new Variant(string))) {
                    this.tableColumns.changeSelection(this.tableColumns.getQuery().getCurrentRecord().getIndex(), 0);
                } else {
                    this.tableColumns.changeSelection(0, 0);
                }
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentTableName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentTableName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableColumns.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmColumnNotNull = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableColumns = new ViewTable();
        this.statusBarColumns = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarColumns = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonColumnNotNull = new ToolButton();
        this.buttonCreateConstraintCheck = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableColumnsPanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableColumnsPanel.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmColumnNotNull.setActionCommandKey("cmColumnNotNull");
        this.cmColumnNotNull.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/lock16.gif"));
        this.cmColumnNotNull.setText(stringManager.getString("TableColumnsPanel-cmColumnNotNull-text"));
        this.cmColumnNotNull.setTooltip(stringManager.getString("TableColumnsPanel-cmColumnNotNull-hint"));
        this.cmColumnNotNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableColumnsPanel.this.cmColumnNotNullActionPerformed(actionEvent);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(stringManager.getString("TableColumnsPanel-cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(stringManager.getString("TableColumnsPanel-cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableColumnsPanel.this.cmCreateConstraintCheckActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TableColumnsPanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableColumns);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarColumns.setShowFieldType(false);
        this.statusBarColumns.setShowOpenTime(false);
        this.statusBarColumns.setTable((QueryTable)this.tableColumns);
        this.add((Component)this.statusBarColumns, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarColumns.setFloatable(false);
        this.toolBarColumns.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarColumns.add(this.jSeparator1);
        this.buttonColumnNotNull.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.buttonColumnNotNull.setHorizontalTextPosition(0);
        this.buttonColumnNotNull.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonColumnNotNull);
        this.buttonCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.buttonCreateConstraintCheck.setHorizontalTextPosition(0);
        this.buttonCreateConstraintCheck.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonCreateConstraintCheck);
        this.toolBarColumns.add(this.jSeparator2);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarColumns.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarColumns);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent actionEvent) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String string = this.tableColumns.getQuery().fieldByName("COLUMNNAME").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
                this.refresh();
            }
            catch (Exception exception) {
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmColumnNotNullActionPerformed(ActionEvent actionEvent) {
        if (this.tableColumns.getSelectedRow() >= 0) {
            try {
                this.tableColumns.getQuery().getRecord(this.tableColumns.getSelectedRow());
                String string = this.tableColumns.getQuery().fieldByName("COLUMNNAME").getString();
                SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterTableNullWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, string, "ALTER"), (boolean)true);
                this.refresh();
            }
            catch (Exception exception) {
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }
}

