/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.AlterTableNullWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintCheckWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintForeignKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.CreateConstraintPrimaryKeyWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;

public class TableConstraintsPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonColumnNotNull;
    private ToolButton buttonCreateConstraintCheck;
    private ToolButton buttonCreateConstraintFK;
    private ToolButton buttonCreateConstraintPrimaryKey;
    private ToolButton buttonDtopConstraint;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSwitchEnabled;
    private Action cmColumnNotNull;
    private Action cmCreateConstraintCheck;
    private Action cmCreateConstraintFK;
    private Action cmCreateConstraintPrimaryKey;
    private Action cmDropConstraint;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSwitchEnabled;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarConstraints;
    private ViewTable tableConstraints;
    private JToolBar toolBarConstraints;

    public TableConstraintsPanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableConstraintsPanel.this.refresh();
            }
        };
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        this.tableConstraints.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableConstraintsPanel.this.tableConstraints.getSelectedRow();
                if (n >= 0 && TableConstraintsPanel.this.tableConstraints.getQuery().isActive()) {
                    try {
                        TableConstraintsPanel.this.tableConstraints.getQuery().getRecord(n);
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
            }
        });
        this.tableConstraints.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("constraintname", stringManager.getString("TableConstraintsPanel-constraint-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("type", stringManager.getString("TableConstraintsPanel-type"), 100, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("enabled", stringManager.getString("TableConstraintsPanel-enabled"), 50, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable jTable, Component component, Object object, boolean bl, boolean bl2) {
                    ((JLabel)component).setHorizontalAlignment(0);
                    if (StringUtil.nvl((Object)object, (Object)"").toString().equals("Y")) {
                        ((JLabel)component).setText(stringManager.getString("yes"));
                    } else {
                        ((JLabel)component).setText("-");
                    }
                }
            })));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("tablename_fk", stringManager.getString("TableConstraintsPanel-foreign-key-table"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("constraintname_fk", stringManager.getString("TableConstraintsPanel-foreign-key-constraint-name"), 150));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("deleterule_fk", stringManager.getString("TableConstraintsPanel-delete-rule"), 100));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("updaterule_fk", stringManager.getString("TableConstraintsPanel-update-rule"), 100));
            this.tableConstraints.addColumn((TableColumn)new QueryTableColumn("checkdefinition", stringManager.getString("TableConstraintsPanel-check-rule"), 200));
            SqlFilterDef sqlFilterDef = new SqlFilterDef();
            sqlFilterDef.add(new SqlFilterDefComponent("cs.constraintname", stringManager.getString("TableConstraintsPanel-constraint-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("(case when cs.type = 'P' then 'Primary Key' when cs.type = 'F' then 'Foreign Key' when cs.type = 'C' then 'Check' when cs.type = 'U' then 'Unique' end)", stringManager.getString("TableConstraintsPanel-constraint-type"), new String[]{"", "'Primary Key'", "'Foreign Key'", "'Check'", "'Unique'"}));
            sqlFilterDef.add(new SqlFilterDefComponent("tfk.tablename", stringManager.getString("TableConstraintsPanel-alien-table"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("csfk.constraintname", stringManager.getString("TableConstraintsPanel-alien-constraint-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("cs.state = 'D'", stringManager.getString("TableConstraintsPanel-constraint-enabled")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-table-constraints-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableConstraints, (JButton)this.buttonActions, this.menuActions, "derbydb-table-constraints-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("TableConstraintsPanel-title");
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableConstraints.getQuery().close();
            this.tableConstraints.getQuery().setSqlText(DerbyDbSql.getTableConstraintList(this.filter.getSqlText()));
            this.tableConstraints.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableConstraints.getQuery().paramByName("tablename").setString(this.currentTableName);
            this.tableConstraints.getQuery().open();
            if (!this.tableConstraints.getQuery().isEmpty()) {
                this.tableConstraints.changeSelection(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentTableName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentTableName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableConstraints.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropConstraint = new Action();
        this.cmSwitchEnabled = new Action();
        this.cmColumnNotNull = new Action();
        this.cmCreateConstraintCheck = new Action();
        this.cmCreateConstraintFK = new Action();
        this.cmCreateConstraintPrimaryKey = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableConstraints = new ViewTable();
        this.statusBarConstraints = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarConstraints = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonSwitchEnabled = new ToolButton();
        this.jSeparator3 = new JSeparator();
        this.buttonColumnNotNull = new ToolButton();
        this.buttonCreateConstraintCheck = new ToolButton();
        this.buttonCreateConstraintFK = new ToolButton();
        this.buttonCreateConstraintPrimaryKey = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopConstraint = new ToolButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmDropConstraint.setActionCommandKey("cmDropConstraint");
        this.cmDropConstraint.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropConstraint.setText(stringManager.getString("TableConstraintsPanel-cmDropConstraint-text"));
        this.cmDropConstraint.setTooltip(stringManager.getString("TableConstraintsPanel-cmDropConstraint-hint"));
        this.cmDropConstraint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmDropConstraintActionPerformed(actionEvent);
            }
        });
        this.cmSwitchEnabled.setActionCommandKey("cmSwitchEnabled");
        this.cmSwitchEnabled.setEnabled(false);
        this.cmSwitchEnabled.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmSwitchEnabled.setText(stringManager.getString("TableConstraintsPanel-cmSwitchEnabled-text"));
        this.cmSwitchEnabled.setTooltip(stringManager.getString("TableConstraintsPanel-cmSwitchEnabled-hint"));
        this.cmColumnNotNull.setActionCommandKey("cmColumnNotNull");
        this.cmColumnNotNull.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/lock16.gif"));
        this.cmColumnNotNull.setText(stringManager.getString("TableConstraintsPanel-cmColumnNotNull-text"));
        this.cmColumnNotNull.setTooltip(stringManager.getString("TableConstraintsPanel-cmColumnNotNull-hint"));
        this.cmColumnNotNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmColumnNotNullActionPerformed(actionEvent);
            }
        });
        this.cmCreateConstraintCheck.setActionCommandKey("cmCreateConstraintCheck");
        this.cmCreateConstraintCheck.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/verify_document_16.gif"));
        this.cmCreateConstraintCheck.setText(stringManager.getString("TableConstraintsPanel-cmCreateConstraintCheck-text"));
        this.cmCreateConstraintCheck.setTooltip(stringManager.getString("TableConstraintsPanel-cmCreateConstraintCheck-hint"));
        this.cmCreateConstraintCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmCreateConstraintCheckActionPerformed(actionEvent);
            }
        });
        this.cmCreateConstraintFK.setActionCommandKey("cmCreateConstraintFK");
        this.cmCreateConstraintFK.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/foreign_key16.gif"));
        this.cmCreateConstraintFK.setText(stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-text"));
        this.cmCreateConstraintFK.setTooltip(stringManager.getString("TableConstraintsPanel-cmCreateConstraintFK-hint"));
        this.cmCreateConstraintFK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmCreateConstraintFKActionPerformed(actionEvent);
            }
        });
        this.cmCreateConstraintPrimaryKey.setActionCommandKey("cmCreateConstraintPrimaryKey");
        this.cmCreateConstraintPrimaryKey.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/primary_key16.gif"));
        this.cmCreateConstraintPrimaryKey.setText(stringManager.getString("TableConstraintsPanel-cmCreateConstraintPrimaryKey-text"));
        this.cmCreateConstraintPrimaryKey.setTooltip(stringManager.getString("TableConstraintsPanel-cmCreateConstraintPrimaryKey-hint"));
        this.cmCreateConstraintPrimaryKey.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConstraintsPanel.this.cmCreateConstraintPrimaryKeyActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TableConstraintsPanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableConstraints);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarConstraints.setShowFieldType(false);
        this.statusBarConstraints.setShowOpenTime(false);
        this.statusBarConstraints.setTable((QueryTable)this.tableConstraints);
        this.add((Component)this.statusBarConstraints, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarConstraints.setFloatable(false);
        this.toolBarConstraints.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarConstraints.add(this.jSeparator2);
        this.buttonSwitchEnabled.setAction((javax.swing.Action)this.cmSwitchEnabled);
        this.buttonSwitchEnabled.setHorizontalTextPosition(0);
        this.buttonSwitchEnabled.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonSwitchEnabled);
        this.jSeparator3.setOrientation(1);
        this.toolBarConstraints.add(this.jSeparator3);
        this.buttonColumnNotNull.setAction((javax.swing.Action)this.cmColumnNotNull);
        this.buttonColumnNotNull.setHorizontalTextPosition(0);
        this.buttonColumnNotNull.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonColumnNotNull);
        this.buttonCreateConstraintCheck.setAction((javax.swing.Action)this.cmCreateConstraintCheck);
        this.buttonCreateConstraintCheck.setHorizontalTextPosition(0);
        this.buttonCreateConstraintCheck.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintCheck);
        this.buttonCreateConstraintFK.setAction((javax.swing.Action)this.cmCreateConstraintFK);
        this.buttonCreateConstraintFK.setHorizontalTextPosition(0);
        this.buttonCreateConstraintFK.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintFK);
        this.buttonCreateConstraintPrimaryKey.setAction((javax.swing.Action)this.cmCreateConstraintPrimaryKey);
        this.buttonCreateConstraintPrimaryKey.setHorizontalTextPosition(0);
        this.buttonCreateConstraintPrimaryKey.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonCreateConstraintPrimaryKey);
        this.jSeparator1.setOrientation(1);
        this.toolBarConstraints.add(this.jSeparator1);
        this.buttonDtopConstraint.setAction((javax.swing.Action)this.cmDropConstraint);
        this.buttonDtopConstraint.setHorizontalTextPosition(0);
        this.buttonDtopConstraint.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonDtopConstraint);
        this.toolBarConstraints.add(this.jSeparator4);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarConstraints.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateConstraintPrimaryKeyActionPerformed(ActionEvent actionEvent) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintPrimaryKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void cmCreateConstraintFKActionPerformed(ActionEvent actionEvent) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintForeignKeyWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void cmCreateConstraintCheckActionPerformed(ActionEvent actionEvent) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateConstraintCheckWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
            this.refresh();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void cmColumnNotNullActionPerformed(ActionEvent actionEvent) {
        try {
            SqlCodeWizardDialog.show((SqlCodeWizardPanel)new AlterTableNullWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName, null, "ALTER"), (boolean)true);
            this.refresh();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void cmDropConstraintActionPerformed(ActionEvent actionEvent) {
        if (this.tableConstraints.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableConstraints.getQuery().getRecord(this.tableConstraints.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableConstraints.getQuery().fieldByName("constraintname").getString(), (Database)this.getDatabase());
                String string2 = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName, (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)stringManager.getString("deleting"), (String)stringManager.getString("TableConstraintsPanel-delete-constraint-q"), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("alter table " + string2 + " drop constraint " + string, true);
                    this.timer.restart();
                }
            }
            catch (Exception exception) {
                MessageBox.show((String)stringManager.getString("error"), (String)exception.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

