/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.orbada.universal.gui.wizards.CreateIndexWizardPanel;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardDialog;
import pl.mpak.orbada.universal.gui.wizards.SqlCodeWizardPanel;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableCellRendererFilter;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.timer.Timer;

public class TableIndexesPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonCreateIndex;
    private ToolButton buttonDtopIndex;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private Action cmCreateIndex;
    private Action cmDropIndex;
    private Action cmFilter;
    private Action cmRefresh;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarIndexes;
    private ViewTable tableIndexes;
    private JToolBar toolBarIndexes;

    public TableIndexesPanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableIndexesPanel.this.refresh();
            }
        };
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        this.tableIndexes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableIndexesPanel.this.tableIndexes.getSelectedRow();
                if (n >= 0 && TableIndexesPanel.this.tableIndexes.getQuery().isActive()) {
                    try {
                        TableIndexesPanel.this.tableIndexes.getQuery().getRecord(n);
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
            }
        });
        this.tableIndexes.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("columnnumber", stringManager.getString("TableIndexesPanel-lp"), 30));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("index_name", stringManager.getString("TableIndexesPanel-index-name"), 200, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("columnname", stringManager.getString("TableIndexesPanel-column"), 150));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("isconstraint", stringManager.getString("TableIndexesPanel-primary-key"), 50, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable jTable, Component component, Object object, boolean bl, boolean bl2) {
                    ((JLabel)component).setHorizontalAlignment(0);
                    if (StringUtil.nvl((Object)object, (Object)"").toString().equals("1")) {
                        ((JLabel)component).setText(stringManager.getString("yes"));
                    } else {
                        ((JLabel)component).setText("-");
                    }
                }
            })));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("isunique", stringManager.getString("TableIndexesPanel-unique"), 50, (TableCellRenderer)new QueryTableCellRenderer(new QueryTableCellRendererFilter(){

                public void cellRendererPerformed(JTable jTable, Component component, Object object, boolean bl, boolean bl2) {
                    ((JLabel)component).setHorizontalAlignment(0);
                    if (StringUtil.nvl((Object)object, (Object)"").toString().equals("1")) {
                        ((JLabel)component).setText(stringManager.getString("yes"));
                    } else {
                        ((JLabel)component).setText("-");
                    }
                }
            })));
            this.tableIndexes.addColumn((TableColumn)new QueryTableColumn("descriptor", stringManager.getString("TableIndexesPanel-type"), 200, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            SqlFilterDef sqlFilterDef = new SqlFilterDef();
            sqlFilterDef.add(new SqlFilterDefComponent("c.conglomeratename", stringManager.getString("TableIndexesPanel-key-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("cols.columnname", stringManager.getString("TableIndexesPanel-column-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("locate('UNIQUE ', cast(c.DESCRIPTOR as varchar(100))) > 0", stringManager.getString("TableIndexesPanel-uniquenes")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-table-indexes-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableIndexes, (JButton)this.buttonActions, this.menuActions, "derbydb-table-indexes-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("TableIndexesPanel-title");
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableIndexes.getQuery().close();
            this.tableIndexes.getQuery().setSqlText(DerbyDbSql.getTableIndexList(this.filter.getSqlText()));
            this.tableIndexes.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableIndexes.getQuery().paramByName("tablename").setString(this.currentTableName);
            this.tableIndexes.getQuery().open();
            if (!this.tableIndexes.getQuery().isEmpty()) {
                this.tableIndexes.changeSelection(0, 0);
            }
        }
        catch (Exception exception) {
            MessageBox.show((String)stringManager.getString("error"), (String)exception.getMessage(), (int)1);
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentTableName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentTableName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableIndexes.getQuery().close();
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropIndex = new Action();
        this.cmCreateIndex = new Action();
        this.menuActions = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.tableIndexes = new ViewTable();
        this.statusBarIndexes = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarIndexes = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonCreateIndex = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopIndex = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableIndexesPanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableIndexesPanel.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmDropIndex.setActionCommandKey("cmDropIndex");
        this.cmDropIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropIndex.setText(stringManager.getString("TableIndexesPanel-cmDropIndex-text"));
        this.cmDropIndex.setTooltip(stringManager.getString("TableIndexesPanel-cmDropIndex-hint"));
        this.cmDropIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableIndexesPanel.this.cmDropIndexActionPerformed(actionEvent);
            }
        });
        this.cmCreateIndex.setActionCommandKey("cmCreateIndex");
        this.cmCreateIndex.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/create_index16.gif"));
        this.cmCreateIndex.setText(stringManager.getString("TableIndexesPanel-cmCreateIndex-text"));
        this.cmCreateIndex.setTooltip(stringManager.getString("TableIndexesPanel-cmCreateIndex-hint"));
        this.cmCreateIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableIndexesPanel.this.cmCreateIndexActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TableIndexesPanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableIndexes);
        this.add((Component)this.jScrollPane1, "Center");
        this.statusBarIndexes.setShowFieldType(false);
        this.statusBarIndexes.setShowOpenTime(false);
        this.statusBarIndexes.setTable((QueryTable)this.tableIndexes);
        this.add((Component)this.statusBarIndexes, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarIndexes.setFloatable(false);
        this.toolBarIndexes.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarIndexes.add(this.jSeparator2);
        this.buttonCreateIndex.setAction((javax.swing.Action)this.cmCreateIndex);
        this.buttonCreateIndex.setHorizontalTextPosition(0);
        this.buttonCreateIndex.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonCreateIndex);
        this.jSeparator1.setOrientation(1);
        this.toolBarIndexes.add(this.jSeparator1);
        this.buttonDtopIndex.setAction((javax.swing.Action)this.cmDropIndex);
        this.buttonDtopIndex.setHorizontalTextPosition(0);
        this.buttonDtopIndex.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonDtopIndex);
        this.toolBarIndexes.add(this.jSeparator3);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarIndexes.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarIndexes);
        this.add((Component)this.jPanel1, "North");
    }

    private void cmCreateIndexActionPerformed(ActionEvent actionEvent) {
        SqlCodeWizardDialog.show((SqlCodeWizardPanel)new CreateIndexWizardPanel(this.getDatabase(), this.currentSchemaName, this.currentTableName), (boolean)true);
        this.timer.restart();
    }

    private void cmDropIndexActionPerformed(ActionEvent actionEvent) {
        if (this.tableIndexes.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableIndexes.getQuery().getRecord(this.tableIndexes.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableIndexes.getQuery().fieldByName("index_name").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)stringManager.getString("deleting"), (String)stringManager.getString("TableIndexesPanel-delete-index-q"), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop index " + string, true);
                    this.timer.restart();
                }
            }
            catch (Exception exception) {
                MessageBox.show((String)stringManager.getString("error"), (String)exception.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

