/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class TableTriggersPanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentTableName = "";
    private boolean requestRefresh = false;
    private SqlFilter filter;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonDropTrigger;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSwitchEnabled;
    private Action cmDropTrigger;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSwitchEnabled;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JPopupMenu menuActions;
    private QueryTableStatusBar statusBarTriggers;
    private OrbadaSyntaxTextArea syntaxTrigger;
    private ViewTable tableTriggers;
    private JToolBar toolBarTriggers;

    public TableTriggersPanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            public void run() {
                this.setEnabled(false);
                TableTriggersPanel.this.refresh();
            }
        };
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        this.syntaxTrigger.setDatabase(this.getDatabase());
        this.syntaxTrigger.setEditable(false);
        this.tableTriggers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableTriggersPanel.this.tableTriggers.getSelectedRow();
                if (n >= 0 && TableTriggersPanel.this.tableTriggers.getQuery().isActive()) {
                    try {
                        TableTriggersPanel.this.tableTriggers.getQuery().getRecord(n);
                        TableTriggersPanel.this.updateTriggerBody();
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                } else {
                    TableTriggersPanel.this.syntaxTrigger.setText("");
                }
            }
        });
        this.tableTriggers.getQuery().setDatabase(this.getDatabase());
        try {
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("triggername", stringManager.getString("TableTriggersPanel-trigger-name"), 150, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("creationtimestamp", stringManager.getString("TableTriggersPanel-created"), 110));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("enabled", stringManager.getString("TableTriggersPanel-state"), 70));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("firingtime", stringManager.getString("TableTriggersPanel-when"), 120));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("event", stringManager.getString("TableTriggersPanel-event"), 80));
            this.tableTriggers.addColumn((TableColumn)new QueryTableColumn("type", stringManager.getString("TableTriggersPanel-for"), 150));
            SqlFilterDef sqlFilterDef = new SqlFilterDef();
            sqlFilterDef.add(new SqlFilterDefComponent("trg.triggername", stringManager.getString("TableTriggersPanel-trigger-name"), (String[])null));
            sqlFilterDef.add(new SqlFilterDefComponent("trg.state = 'D'", stringManager.getString("TableTriggersPanel-disabled")));
            this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-table-triggers-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTriggers, (JButton)this.buttonActions, this.menuActions, "derbydb-table-triggers-actions");
    }

    public String getTitle() {
        return stringManager.getString("TableTriggersPanel-title");
    }

    public void refresh() {
        try {
            this.requestRefresh = false;
            this.tableTriggers.getQuery().close();
            this.tableTriggers.getQuery().setSqlText(DerbyDbSql.getTableTriggerList(this.filter.getSqlText()));
            this.tableTriggers.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableTriggers.getQuery().paramByName("tablename").setString(this.currentTableName);
            this.tableTriggers.getQuery().open();
            if (!this.tableTriggers.getQuery().isEmpty()) {
                this.tableTriggers.changeSelection(0, 0);
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTriggerBody() {
        try {
            String string = "";
            String string2 = "CREATE TRIGGER " + this.tableTriggers.getQuery().fieldByName("triggername").getString() + "\n";
            if (!this.tableTriggers.getQuery().fieldByName("referencedcolumns").isNull()) {
                Query query = this.getDatabase().createQuery();
                try {
                    query.setSqlText("select columnname from sys.syscolumns where referenceid = :tableid and columnnumber in " + this.tableTriggers.getQuery().fieldByName("referencedcolumns").getString());
                    query.paramByName("tableid").setString(this.tableTriggers.getQuery().fieldByName("tableid").getString());
                    query.open();
                    while (!query.eof()) {
                        if (string.length() > 0) {
                            string = string + ", ";
                        }
                        string = string + query.fieldByName("columnname").getString();
                        query.next();
                    }
                }
                catch (Exception exception) {
                    ExceptionUtil.processException((Throwable)exception);
                    this.syntaxTrigger.setText("");
                }
                finally {
                    query.close();
                }
            }
            string2 = string2 + this.tableTriggers.getQuery().fieldByName("firingtime").getString() + " " + this.tableTriggers.getQuery().fieldByName("event").getString() + (string.length() > 0 ? " OF " + string : "") + " ON " + SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.currentTableName, (Database)this.getDatabase()) + "\n";
            if (!this.tableTriggers.getQuery().fieldByName("referencingold").isNull() || !this.tableTriggers.getQuery().fieldByName("referencingnew").isNull()) {
                string2 = string2 + "REFERENCING";
                if (!this.tableTriggers.getQuery().fieldByName("referencingold").isNull()) {
                    string2 = string2 + " " + this.tableTriggers.getQuery().fieldByName("referencingold").getString();
                }
                if (!this.tableTriggers.getQuery().fieldByName("referencingnew").isNull()) {
                    string2 = string2 + " " + this.tableTriggers.getQuery().fieldByName("referencingnew").getString();
                }
                string2 = string2 + "\n";
            }
            string2 = string2 + this.tableTriggers.getQuery().fieldByName("type").getString() + "\n";
            string2 = string2 + this.tableTriggers.getQuery().fieldByName("triggerdefinition").getString();
            this.syntaxTrigger.setText(string2);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
            this.syntaxTrigger.setText(exception.getMessage());
        }
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentTableName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentTableName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.tableTriggers.getQuery().close();
        this.syntaxTrigger.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmFilter = new Action();
        this.cmDropTrigger = new Action();
        this.cmSwitchEnabled = new Action();
        this.menuActions = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTriggers = new ViewTable();
        this.statusBarTriggers = new QueryTableStatusBar();
        this.syntaxTrigger = new OrbadaSyntaxTextArea();
        this.jPanel2 = new JPanel();
        this.toolBarTriggers = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator2 = new JSeparator();
        this.buttonSwitchEnabled = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDropTrigger = new ToolButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableTriggersPanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableTriggersPanel.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmDropTrigger.setActionCommandKey("cmDropTrigger");
        this.cmDropTrigger.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTrigger.setText(stringManager.getString("TableTriggersPanel-cmDropTrigger-text"));
        this.cmDropTrigger.setTooltip(stringManager.getString("TableTriggersPanel-cmDropTrigger-hint"));
        this.cmDropTrigger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableTriggersPanel.this.cmDropTriggerActionPerformed(actionEvent);
            }
        });
        this.cmSwitchEnabled.setActionCommandKey("cmSwitchEnabled");
        this.cmSwitchEnabled.setEnabled(false);
        this.cmSwitchEnabled.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/enabled.gif"));
        this.cmSwitchEnabled.setText(stringManager.getString("TableTriggersPanel-cmSwitchEnabled-text"));
        this.cmSwitchEnabled.setTooltip(stringManager.getString("TableTriggersPanel-cmSwitchEnabled-hint"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TableTriggersPanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTriggers);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.statusBarTriggers.setShowFieldType(false);
        this.statusBarTriggers.setShowOpenTime(false);
        this.statusBarTriggers.setTable((QueryTable)this.tableTriggers);
        this.jPanel1.add((Component)this.statusBarTriggers, "South");
        this.add((Component)this.jPanel1, "Center");
        this.syntaxTrigger.setPreferredSize(new Dimension(81, 150));
        this.add((Component)this.syntaxTrigger, "South");
        this.jPanel2.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTriggers.setFloatable(false);
        this.toolBarTriggers.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonRefresh);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonFilter);
        this.jSeparator2.setOrientation(1);
        this.toolBarTriggers.add(this.jSeparator2);
        this.buttonSwitchEnabled.setAction((javax.swing.Action)this.cmSwitchEnabled);
        this.buttonSwitchEnabled.setHorizontalTextPosition(0);
        this.buttonSwitchEnabled.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonSwitchEnabled);
        this.jSeparator1.setOrientation(1);
        this.toolBarTriggers.add(this.jSeparator1);
        this.buttonDropTrigger.setAction((javax.swing.Action)this.cmDropTrigger);
        this.buttonDropTrigger.setHorizontalTextPosition(0);
        this.buttonDropTrigger.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonDropTrigger);
        this.toolBarTriggers.add(this.jSeparator3);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarTriggers.add((Component)this.buttonActions);
        this.jPanel2.add(this.toolBarTriggers);
        this.add((Component)this.jPanel2, "North");
    }

    private void cmDropTriggerActionPerformed(ActionEvent actionEvent) {
        if (this.tableTriggers.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTriggers.getQuery().getRecord(this.tableTriggers.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableTriggers.getQuery().fieldByName("triggername").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)stringManager.getString("deleting"), (String)stringManager.getString("TableTriggersPanel-delete-trigger-q"), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop trigger " + string, true);
                    this.timer.restart();
                }
            }
            catch (Exception exception) {
                MessageBox.show((String)stringManager.getString("error"), (String)exception.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentTableName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

