/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.tables;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.tables.TableColumnsPanel;
import pl.mpak.orbada.derbydb.tables.TableConstraintsPanel;
import pl.mpak.orbada.derbydb.tables.TableIndexesPanel;
import pl.mpak.orbada.derbydb.tables.TableTriggersPanel;
import pl.mpak.orbada.gui.ContentPanel;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTable;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class TablesPanelView
extends JPanel
implements IRootTabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonActions;
    private ToolButton buttonDtopTable;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmDropTable;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu menuActions;
    private JPanel panelTables;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBarTables;
    private JTabbedPane tabbedTableInfo;
    private ViewTable tableTables;
    private JToolBar toolBarTables;

    public TablesPanelView(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = this.getDatabase().getUserName().toUpperCase();
        this.tableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = "";
                int n = TablesPanelView.this.tableTables.getSelectedRow();
                if (n >= 0 && TablesPanelView.this.tableTables.getQuery().isActive()) {
                    try {
                        TablesPanelView.this.tableTables.getQuery().getRecord(n);
                        string = TablesPanelView.this.tableTables.getQuery().fieldByName("tablename").getString();
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
                for (int i = 0; i < TablesPanelView.this.tabbedTableInfo.getTabCount(); ++i) {
                    Component component = TablesPanelView.this.tabbedTableInfo.getComponentAt(i);
                    if (!(component instanceof ITabObjectInfo)) continue;
                    ((ITabObjectInfo)component).refresh(null, TablesPanelView.this.currentSchemaName, string);
                }
            }
        });
        this.addInfoPanel(stringManager.getString("TablesPanelView-columns"), new TableColumnsPanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("TablesPanelView-indexes"), new TableIndexesPanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("TablesPanelView-constraints"), new TableConstraintsPanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("TablesPanelView-triggers"), new TableTriggersPanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("TablesPanelView-datas"), (JPanel)new ContentPanel(this.accesibilities));
        this.tableTables.getQuery().setDatabase(this.getDatabase());
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("tablename", stringManager.getString("TablesPanelView-table-name"), 120, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableTables.addColumn((TableColumn)new QueryTableColumn("authorizationid", stringManager.getString("TablesPanelView-authorization"), 120));
        SqlFilterDef sqlFilterDef = new SqlFilterDef();
        sqlFilterDef.add(new SqlFilterDefComponent("t.tablename", stringManager.getString("TablesPanelView-table-name"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-tables-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.tableTables, (JButton)this.buttonActions, this.menuActions, "derbydb-tables-actions");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TablesPanelView.this.tableTables.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String string) {
        if (!this.currentSchemaName.equals(string)) {
            this.currentSchemaName = string;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getDatabase().getUserName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String string = null;
            if (this.tableTables.getQuery().isActive() && this.tableTables.getSelectedRow() >= 0) {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectedRow());
                string = this.tableTables.getQuery().fieldByName("TABLENAME").getString();
            }
            this.refresh(string);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string) {
        try {
            int n = Math.max(0, this.tableTables.getSelectedRow());
            this.tableTables.getQuery().close();
            this.tableTables.getQuery().setSqlText(DerbyDbSql.getTableList(this.filter.getSqlText()));
            this.tableTables.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableTables.getQuery().open();
            if (string != null && this.tableTables.getQuery().locate("TABLENAME", new Variant(string))) {
                this.tableTables.changeSelection(this.tableTables.getQuery().getCurrentRecord().getIndex(), this.tableTables.getSelectedColumn());
            } else if (!this.tableTables.getQuery().isEmpty()) {
                this.tableTables.changeSelection(Math.min(n, this.tableTables.getRowCount() - 1), this.tableTables.getSelectedColumn());
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void addInfoPanel(String string, JPanel jPanel) {
        this.tabbedTableInfo.addTab(string, jPanel);
        this.tabbedTableInfo.setTabComponentAt(this.tabbedTableInfo.indexOfComponent(jPanel), (Component)new TabCloseComponent(string));
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        int n = 0;
        while (n < this.tabbedTableInfo.getTabCount()) {
            Component component = this.tabbedTableInfo.getComponentAt(n);
            if (component instanceof Closeable) {
                try {
                    ((Closeable)((Object)component)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++n;
            }
            this.tabbedTableInfo.remove(component);
        }
        this.tableTables.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropTable = new Action();
        this.menuActions = new JPopupMenu();
        this.splinPane = new JSplitPane();
        this.panelTables = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableTables = new ViewTable();
        this.statusBarTables = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarTables = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopTable = new ToolButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.tabbedTableInfo = new JTabbedPane();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablesPanelView.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablesPanelView.this.cmSelectSchemaActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablesPanelView.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmDropTable.setActionCommandKey("cmDropTable");
        this.cmDropTable.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropTable.setText(stringManager.getString("TablesPanelView-cmDropTable-text"));
        this.cmDropTable.setTooltip(stringManager.getString("TablesPanelView-cmDropTable-hint"));
        this.cmDropTable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TablesPanelView.this.cmDropTableActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                TablesPanelView.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(200);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelTables.setPreferredSize(new Dimension(250, 100));
        this.panelTables.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableTables);
        this.panelTables.add((Component)this.jScrollPane1, "Center");
        this.statusBarTables.setShowFieldType(false);
        this.statusBarTables.setShowFieldValue(false);
        this.statusBarTables.setShowOpenTime(false);
        this.statusBarTables.setTable((QueryTable)this.tableTables);
        this.panelTables.add((Component)this.statusBarTables, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarTables.setFloatable(false);
        this.toolBarTables.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarTables.add(this.jSeparator1);
        this.buttonDtopTable.setAction((javax.swing.Action)this.cmDropTable);
        this.buttonDtopTable.setHorizontalTextPosition(0);
        this.buttonDtopTable.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonDtopTable);
        this.toolBarTables.add(this.jSeparator2);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarTables.add((Component)this.buttonActions);
        this.jPanel1.add(this.toolBarTables);
        this.panelTables.add((Component)this.jPanel1, "North");
        this.splinPane.setLeftComponent(this.panelTables);
        this.tabbedTableInfo.setFocusable(false);
        this.splinPane.setRightComponent(this.tabbedTableInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void cmDropTableActionPerformed(ActionEvent actionEvent) {
        if (this.tableTables.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableTables.getQuery().getRecord(this.tableTables.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableTables.getQuery().fieldByName("tablename").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)this, (String)stringManager.getString("deleting"), (String)stringManager.getString("TablesPanelView-delete-table-q"), (int[])ModalResult.YESNO, (int)3) == 5) {
                    this.getDatabase().createCommand("drop table " + string, true);
                    this.refresh(null);
                }
            }
            catch (Exception exception) {
                MessageBox.show((Component)this, (String)stringManager.getString("error"), (String)exception.getMessage(), (int)1, (int)0);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        if (!this.tableTables.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent actionEvent) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open("select schemaname from sys.sysschemas order by schemaname");
            Vector vector = QueryUtil.staticData((String)"{schemaname}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vector, (int)vector.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object object) {
                    TablesPanelView.this.setCurrentSchemaName(object.toString());
                    TablesPanelView.this.refresh();
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

