/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.universal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.Closeable;
import java.io.IOException;
import java.sql.ResultSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pl.mpak.sky.gui.swing.comp.TextArea;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;

public class StatisticsPanel
extends JPanel
implements Closeable {
    private Database database;
    private JScrollPane jScrollPane1;
    private TextArea textStatistics;

    public StatisticsPanel(Database database) {
        this.database = database;
        this.initComponents();
        this.init();
    }

    private void init() {
        try {
            this.database.executeCommand("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
            this.database.executeCommand("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(1)");
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void close() throws IOException {
        try {
            this.database.executeCommand("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
            this.database.executeCommand("CALL SYSCS_UTIL.SYSCS_SET_STATISTICS_TIMING(0)");
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void beforeSql() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterSql() {
        block5: {
            Command command = this.database.createCommand();
            try {
                ResultSet resultSet;
                command.execute("VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
                if (command.getStatement() == null || (resultSet = command.getStatement().getResultSet()) == null) break block5;
                Query query = this.database.createQuery();
                try {
                    query.setResultSet(resultSet);
                    this.textStatistics.setText(query.getField(0).getString());
                }
                finally {
                    query.close();
                }
            }
            catch (Exception exception) {
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textStatistics = new TextArea();
        this.setLayout(new BorderLayout());
        this.textStatistics.setColumns(20);
        this.textStatistics.setEditable(false);
        this.textStatistics.setRows(5);
        this.textStatistics.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane1.setViewportView((Component)this.textStatistics);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

