/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.procedures.FunctionsPanelView;
import pl.mpak.orbada.derbydb.procedures.ProceduresPanelView;
import pl.mpak.orbada.derbydb.services.DerbyDbFunctionsView;
import pl.mpak.orbada.derbydb.services.DerbyDbProceduresView;
import pl.mpak.orbada.derbydb.services.DerbyDbTablesView;
import pl.mpak.orbada.derbydb.services.DerbyDbViewsView;
import pl.mpak.orbada.derbydb.tables.TablesPanelView;
import pl.mpak.orbada.derbydb.views.ViewsPanelView;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.providers.ViewProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TableRowChangeKeyListener;
import pl.mpak.sky.gui.swing.comp.TextField;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;

public class DerbyDbSearchObjectDialog
extends JDialog {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IPerspectiveAccesibilities accesibilities;
    private int modalResult = 1;
    private JButton buttonCancel;
    private JButton buttonOk;
    private Action cmCancel;
    private Action cmGo;
    private Action cmSearch;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private ViewTable tableObjects;
    private TextField textSearch;

    public DerbyDbSearchObjectDialog(IPerspectiveAccesibilities iPerspectiveAccesibilities) {
        this.accesibilities = iPerspectiveAccesibilities;
        this.initComponents();
        this.init();
    }

    public static void showDialog(IPerspectiveAccesibilities iPerspectiveAccesibilities) {
        DerbyDbSearchObjectDialog derbyDbSearchObjectDialog = new DerbyDbSearchObjectDialog(iPerspectiveAccesibilities);
        derbyDbSearchObjectDialog.setVisible(true);
    }

    private void init() {
        SwingUtil.centerWithinScreen((Window)this);
        this.getRootPane().getInputMap(2).put(this.cmCancel.getShortCut(), "cmCancel");
        this.getRootPane().getActionMap().put("cmCancel", (javax.swing.Action)this.cmCancel);
        this.getRootPane().setDefaultButton(this.buttonOk);
        SwingUtil.addAction((JDialog)this, (String)this.cmSearch.getActionCommandKey(), (javax.swing.Action)this.cmSearch);
        this.textSearch.addKeyListener((KeyListener)new TableRowChangeKeyListener((JTable)this.tableObjects));
        this.tableObjects.getQuery().setDatabase(this.accesibilities.getDatabase());
        try {
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("schemaname", stringManager.getString("DerbyDbSearchObjectDialog-schema"), 150));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("objectname", stringManager.getString("DerbyDbSearchObjectDialog-object-name"), 250, (TableCellRenderer)new QueryTableCellRenderer(1)));
            this.tableObjects.addColumn((TableColumn)new QueryTableColumn("objecttype", stringManager.getString("DerbyDbSearchObjectDialog-type"), 150, (TableCellRenderer)new QueryTableCellRenderer(SwingUtil.Color.GREEN)));
            this.tableObjects.getQuery().setSqlText(DerbyDbSql.getObjectList() + "\n where x.objecttype <> 'INDEX' and (x.objectname like '%'||:objectname||'%' or x.objectname like '%'||upper(:objectname)||'%')");
        }
        catch (UseDBException useDBException) {
            ExceptionUtil.processException((Throwable)useDBException);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DerbyDbSearchObjectDialog.this.textSearch.requestFocusInWindow();
            }
        });
    }

    public void dispose() {
        this.tableObjects.getQuery().close();
        super.dispose();
    }

    private void initComponents() {
        this.cmSearch = new Action();
        this.cmCancel = new Action();
        this.cmGo = new Action();
        this.jLabel1 = new JLabel();
        this.textSearch = new TextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableObjects = new ViewTable();
        this.buttonOk = new JButton();
        this.buttonCancel = new JButton();
        this.cmSearch.setActionCommandKey("cmSearch");
        this.cmSearch.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmSearch.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/go16.gif"));
        this.cmSearch.setTooltip(stringManager.getString("DerbyDbSearchObjectDialog-cmSearch-hint"));
        this.cmSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyDbSearchObjectDialog.this.cmSearchActionPerformed(actionEvent);
            }
        });
        this.cmCancel.setActionCommandKey("cmCancel");
        this.cmCancel.setShortCut(KeyStroke.getKeyStroke(27, 0));
        this.cmCancel.setText(stringManager.getString("cmCancel-text"));
        this.cmCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyDbSearchObjectDialog.this.cmCancelActionPerformed(actionEvent);
            }
        });
        this.cmGo.setActionCommandKey("cmGo");
        this.cmGo.setEnabled(false);
        this.cmGo.setText(stringManager.getString("cmGo-text"));
        this.cmGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DerbyDbSearchObjectDialog.this.cmGoActionPerformed(actionEvent);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle(stringManager.getString("DerbyDbSearchObjectDialog-title"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DerbyDbSearchObjectDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.jLabel1.setText(stringManager.getString("DerbyDbSearchObjectDialog-object-name-dd"));
        this.jButton1.setAction((javax.swing.Action)this.cmSearch);
        this.jButton1.setMargin(new Insets(1, 1, 1, 1));
        this.jScrollPane1.setViewportView((Component)this.tableObjects);
        this.buttonOk.setAction((javax.swing.Action)this.cmGo);
        this.buttonOk.setMargin(new Insets(2, 2, 2, 2));
        this.buttonOk.setPreferredSize(new Dimension(75, 23));
        this.buttonCancel.setAction((javax.swing.Action)this.cmCancel);
        this.buttonCancel.setMargin(new Insets(2, 2, 2, 2));
        this.buttonCancel.setPreferredSize(new Dimension(75, 23));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 569, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.textSearch, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.buttonOk, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCancel, -2, -1, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel1).addComponent((Component)this.textSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.buttonCancel, -2, -1, -2).addComponent(this.buttonOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.tableObjects.getQuery().close();
    }

    private void cmSearchActionPerformed(ActionEvent actionEvent) {
        if (!"".equals(this.textSearch.getText())) {
            try {
                this.tableObjects.getQuery().close();
                this.tableObjects.getQuery().paramByName("objectname").setString(this.textSearch.getText());
                this.tableObjects.getQuery().open();
                this.cmGo.setEnabled(!this.tableObjects.getQuery().eof());
                if (!this.tableObjects.getQuery().eof()) {
                    this.tableObjects.changeSelection(0, this.tableObjects.getSelectedColumn());
                }
            }
            catch (Exception exception) {
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void cmGoActionPerformed(ActionEvent actionEvent) {
        try {
            this.tableObjects.getQuery().getRecord(this.tableObjects.getSelectedRow());
            final String string = this.tableObjects.getQuery().fieldByName("schemaname").getString();
            final String string2 = this.tableObjects.getQuery().fieldByName("objectname").getString();
            String string3 = this.tableObjects.getQuery().fieldByName("objecttype").getString();
            if ("TABLE".equals(string3) || "SYSTEM TABLE".equals(string3)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DerbyDbTablesView[] derbyDbTablesViewArray = (DerbyDbTablesView[])DerbyDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(DerbyDbTablesView.class);
                        if (derbyDbTablesViewArray != null && derbyDbTablesViewArray.length > 0) {
                            TablesPanelView tablesPanelView = (TablesPanelView)DerbyDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)derbyDbTablesViewArray[0]);
                            if (tablesPanelView == null) {
                                tablesPanelView = (TablesPanelView)DerbyDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)derbyDbTablesViewArray[0]);
                            }
                            tablesPanelView.setCurrentSchemaName(string);
                            tablesPanelView.refresh(string2);
                            DerbyDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)tablesPanelView);
                        }
                    }
                });
            } else if ("VIEW".equals(string3)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DerbyDbViewsView[] derbyDbViewsViewArray = (DerbyDbViewsView[])DerbyDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(DerbyDbViewsView.class);
                        if (derbyDbViewsViewArray != null && derbyDbViewsViewArray.length > 0) {
                            ViewsPanelView viewsPanelView = (ViewsPanelView)DerbyDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)derbyDbViewsViewArray[0]);
                            if (viewsPanelView == null) {
                                viewsPanelView = (ViewsPanelView)DerbyDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)derbyDbViewsViewArray[0]);
                            }
                            viewsPanelView.setCurrentSchemaName(string);
                            viewsPanelView.refresh(string2);
                            DerbyDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)viewsPanelView);
                        }
                    }
                });
            } else if ("PROCEDURE".equals(string3)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DerbyDbProceduresView[] derbyDbProceduresViewArray = (DerbyDbProceduresView[])DerbyDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(DerbyDbProceduresView.class);
                        if (derbyDbProceduresViewArray != null && derbyDbProceduresViewArray.length > 0) {
                            ProceduresPanelView proceduresPanelView = (ProceduresPanelView)DerbyDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)derbyDbProceduresViewArray[0]);
                            if (proceduresPanelView == null) {
                                proceduresPanelView = (ProceduresPanelView)DerbyDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)derbyDbProceduresViewArray[0]);
                            }
                            proceduresPanelView.setCurrentSchemaName(string);
                            proceduresPanelView.refresh(string2);
                            DerbyDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)proceduresPanelView);
                        }
                    }
                });
            } else if ("FUNCTION".equals(string3)) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DerbyDbFunctionsView[] derbyDbFunctionsViewArray = (DerbyDbFunctionsView[])DerbyDbSearchObjectDialog.this.accesibilities.getApplication().getServiceArray(DerbyDbFunctionsView.class);
                        if (derbyDbFunctionsViewArray != null && derbyDbFunctionsViewArray.length > 0) {
                            FunctionsPanelView functionsPanelView = (FunctionsPanelView)DerbyDbSearchObjectDialog.this.accesibilities.getViewComponent((ViewProvider)derbyDbFunctionsViewArray[0]);
                            if (functionsPanelView == null) {
                                functionsPanelView = (FunctionsPanelView)DerbyDbSearchObjectDialog.this.accesibilities.createView((ViewProvider)derbyDbFunctionsViewArray[0]);
                            }
                            functionsPanelView.setCurrentSchemaName(string);
                            functionsPanelView.refresh(string2);
                            DerbyDbSearchObjectDialog.this.accesibilities.setSelectedView((Component)functionsPanelView);
                        }
                    }
                });
            }
            this.modalResult = 1;
            this.dispose();
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void cmCancelActionPerformed(ActionEvent actionEvent) {
        this.modalResult = 2;
        this.dispose();
    }
}

