/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.cm.ComponentActionsAction;
import pl.mpak.orbada.gui.comps.OrbadaSyntaxTextArea;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.timer.Timer;

public class ViewSourcePanel
extends JPanel
implements ITabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName = "";
    private String currentViewName = "";
    private boolean requestRefresh = false;
    private Timer timer;
    private ToolButton buttonActions;
    private ToolButton buttonCompile;
    private ToolButton buttonRefresh;
    private Action cmCompile;
    private Action cmRefresh;
    private JToolBar.Separator jSeparator1;
    private JPopupMenu menuActions;
    private OrbadaSyntaxTextArea syntaxViewSource;
    private JToolBar toolBarContent;

    public ViewSourcePanel(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.initComponents();
        this.init();
    }

    private void setEditorText(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ViewSourcePanel.this.syntaxViewSource.setText(string);
            }
        });
    }

    private void init() {
        this.timer = new Timer(250L){
            {
                this.setEnabled(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.setEnabled(false);
                ViewSourcePanel.this.requestRefresh = false;
                Query query = ViewSourcePanel.this.getDatabase().createQuery();
                try {
                    query.setSqlText(DerbyDbSql.getViewSource());
                    query.paramByName("schemaname").setString(ViewSourcePanel.this.currentSchemaName);
                    query.paramByName("viewname").setString(ViewSourcePanel.this.currentViewName);
                    query.open();
                    if (!query.eof()) {
                        ViewSourcePanel.this.setEditorText("drop view \"" + ViewSourcePanel.this.currentSchemaName + "\".\"" + ViewSourcePanel.this.currentViewName + "\"\n/\n" + query.fieldByName("viewdefinition").getString() + "\n/");
                    } else {
                        ViewSourcePanel.this.setEditorText("");
                    }
                    ViewSourcePanel.this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(" ");
                }
                catch (Exception exception) {
                    ExceptionUtil.processException((Throwable)exception);
                }
                finally {
                    query.close();
                }
            }
        };
        SwingUtil.addAction((JComponent)this.syntaxViewSource.getEditorArea(), (javax.swing.Action)this.cmCompile);
        this.syntaxViewSource.getStatusBar().addPanel("view-status").setText(" ");
        this.syntaxViewSource.setDatabase(this.getDatabase());
        OrbadaDerbyDbPlugin.getRefreshQueue().add(this.timer);
        new ComponentActionsAction(this.getDatabase(), (JComponent)this.syntaxViewSource.getEditorArea(), (JButton)this.buttonActions, this.menuActions, "derbydb-view-source-actions");
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    public String getTitle() {
        return stringManager.getString("ViewSourcePanel-title");
    }

    public void refresh() {
        this.refresh(null, this.currentSchemaName, this.currentViewName);
    }

    public void refresh(String string, String string2, String string3) {
        if (!this.currentSchemaName.equals(string2) || !this.currentViewName.equals(string3) || this.requestRefresh) {
            this.currentSchemaName = string2;
            this.currentViewName = string3;
            if (this.isVisible()) {
                this.timer.restart();
            } else {
                this.requestRefresh = true;
                this.setEditorText("");
            }
        }
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.timer.cancel();
        this.syntaxViewSource.setDatabase(null);
        this.accesibilities = null;
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmCompile = new Action();
        this.menuActions = new JPopupMenu();
        this.toolBarContent = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonCompile = new ToolButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.buttonActions = new ToolButton();
        this.syntaxViewSource = new OrbadaSyntaxTextArea();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("ViewSourcePanel-cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewSourcePanel.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmCompile.setActionCommandKey("cmCompile");
        this.cmCompile.setShortCut(KeyStroke.getKeyStroke(10, 2));
        this.cmCompile.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/execute_script16.gif"));
        this.cmCompile.setText(stringManager.getString("ViewSourcePanel-cmCompile-text"));
        this.cmCompile.setTooltip(stringManager.getString("ViewSourcePanel-cmCompile-hint"));
        this.cmCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewSourcePanel.this.cmCompileActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ViewSourcePanel.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.toolBarContent.setFloatable(false);
        this.toolBarContent.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonRefresh);
        this.buttonCompile.setAction((javax.swing.Action)this.cmCompile);
        this.buttonCompile.setHorizontalTextPosition(0);
        this.buttonCompile.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonCompile);
        this.toolBarContent.add(this.jSeparator1);
        this.buttonActions.setHorizontalTextPosition(0);
        this.buttonActions.setVerticalTextPosition(3);
        this.toolBarContent.add((Component)this.buttonActions);
        this.add((Component)this.toolBarContent, "First");
        this.add((Component)this.syntaxViewSource, "Center");
    }

    private void cmCompileActionPerformed(ActionEvent actionEvent) {
        if (MessageBox.show((Component)null, (String)stringManager.getString("ViewSourcePanel-script"), (String)stringManager.getString("ViewSourcePanel-execute-script-q"), (int[])ModalResult.YESNO) != 5) {
            return;
        }
        try {
            this.getDatabase().executeScript(this.syntaxViewSource.getText());
            this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(stringManager.getString("ViewSourcePanel-exec-properly"));
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
            this.syntaxViewSource.getStatusBar().getPanel("view-status").setText(exception.getMessage());
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.refresh(null, this.currentSchemaName, this.currentViewName);
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.timer.restart();
    }
}

