/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.derbydb.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pl.mpak.orbada.derbydb.DerbyDbSql;
import pl.mpak.orbada.derbydb.OrbadaDerbyDbPlugin;
import pl.mpak.orbada.derbydb.tables.TableColumnsPanel;
import pl.mpak.orbada.derbydb.views.ViewSourcePanel;
import pl.mpak.orbada.gui.ContentPanel;
import pl.mpak.orbada.gui.IRootTabObjectInfo;
import pl.mpak.orbada.gui.ITabObjectInfo;
import pl.mpak.orbada.gui.comps.table.ViewTable;
import pl.mpak.orbada.gui.util.SimpleSelectDialog;
import pl.mpak.orbada.plugins.IViewAccesibilities;
import pl.mpak.orbada.universal.gui.filter.SqlFilter;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDef;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDefComponent;
import pl.mpak.orbada.universal.gui.filter.SqlFilterDialog;
import pl.mpak.sky.gui.mr.ModalResult;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.sky.gui.swing.TabCloseComponent;
import pl.mpak.sky.gui.swing.comp.ToolButton;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.usedb.gui.swing.QueryTableCellRenderer;
import pl.mpak.usedb.gui.swing.QueryTableColumn;
import pl.mpak.usedb.gui.swing.QueryTableStatusBar;
import pl.mpak.usedb.util.QueryUtil;
import pl.mpak.usedb.util.SQLUtil;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.variant.Variant;

public class ViewsPanelView
extends JPanel
implements IRootTabObjectInfo {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(OrbadaDerbyDbPlugin.class);
    private IViewAccesibilities accesibilities;
    private String currentSchemaName;
    private String tabTitle;
    private SqlFilter filter;
    private boolean viewClosing = false;
    private ToolButton buttonDtopView;
    private ToolButton buttonFilter;
    private ToolButton buttonRefresh;
    private ToolButton buttonSelectSchema;
    private Action cmDropView;
    private Action cmFilter;
    private Action cmRefresh;
    private Action cmSelectSchema;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPanel panelViews;
    private JSplitPane splinPane;
    private QueryTableStatusBar statusBarViews;
    private JTabbedPane tabbedViewInfo;
    private ViewTable tableViews;
    private JToolBar toolBarViews;

    public ViewsPanelView(IViewAccesibilities iViewAccesibilities) {
        this.accesibilities = iViewAccesibilities;
        this.tabTitle = this.accesibilities.getTabTitle();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.currentSchemaName = this.getDatabase().getUserName().toUpperCase();
        this.tableViews.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = "";
                int n = ViewsPanelView.this.tableViews.getSelectedRow();
                if (n >= 0 && ViewsPanelView.this.tableViews.getQuery().isActive()) {
                    try {
                        ViewsPanelView.this.tableViews.getQuery().getRecord(n);
                        string = ViewsPanelView.this.tableViews.getQuery().fieldByName("viewname").getString();
                    }
                    catch (Exception exception) {
                        ExceptionUtil.processException((Throwable)exception);
                    }
                }
                for (int i = 0; i < ViewsPanelView.this.tabbedViewInfo.getTabCount(); ++i) {
                    Component component = ViewsPanelView.this.tabbedViewInfo.getComponentAt(i);
                    if (!(component instanceof ITabObjectInfo)) continue;
                    ((ITabObjectInfo)component).refresh(null, ViewsPanelView.this.currentSchemaName, string);
                }
            }
        });
        this.addInfoPanel(stringManager.getString("ViewsPanelView-columns"), new TableColumnsPanel(this.accesibilities, true));
        this.addInfoPanel(stringManager.getString("ViewsPanelView-source"), new ViewSourcePanel(this.accesibilities));
        this.addInfoPanel(stringManager.getString("ViewsPanelView-datas"), (JPanel)new ContentPanel(this.accesibilities));
        this.tableViews.getQuery().setDatabase(this.getDatabase());
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("viewname", stringManager.getString("ViewsPanelView-view-name"), 120, (TableCellRenderer)new QueryTableCellRenderer(1)));
        this.tableViews.addColumn((TableColumn)new QueryTableColumn("authorizationid", stringManager.getString("ViewsPanelView-authorization"), 120));
        SqlFilterDef sqlFilterDef = new SqlFilterDef();
        sqlFilterDef.add(new SqlFilterDefComponent("t.tablename", stringManager.getString("ViewsPanelView-view-name"), (String[])null));
        this.filter = new SqlFilter(this.accesibilities.getApplication().getSettings(this.getDatabase().getUserProperties().getProperty("schemaId"), "derbydb-views-filter"), (javax.swing.Action)this.cmFilter, (AbstractButton)this.buttonFilter, sqlFilterDef);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ViewsPanelView.this.tableViews.requestFocusInWindow();
            }
        });
    }

    public void setCurrentSchemaName(String string) {
        if (!this.currentSchemaName.equals(string)) {
            this.currentSchemaName = string;
            if (!this.currentSchemaName.equalsIgnoreCase(this.getDatabase().getUserName())) {
                this.accesibilities.setTabTitle(this.tabTitle + " (" + this.currentSchemaName + ")");
            } else {
                this.accesibilities.setTabTitle(this.tabTitle);
            }
        }
    }

    public void refresh() {
        if (!this.isVisible() || this.viewClosing) {
            return;
        }
        try {
            String string = null;
            if (this.tableViews.getQuery().isActive() && this.tableViews.getSelectedRow() >= 0) {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectedRow());
                string = this.tableViews.getQuery().fieldByName("VIEWNAME").getString();
            }
            this.refresh(string);
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    public void refresh(String string) {
        try {
            int n = Math.max(0, this.tableViews.getSelectedRow());
            this.tableViews.getQuery().close();
            this.tableViews.getQuery().setSqlText(DerbyDbSql.getViewList(this.filter.getSqlText()));
            this.tableViews.getQuery().paramByName("schemaname").setString(this.currentSchemaName);
            this.tableViews.getQuery().open();
            if (string != null && this.tableViews.getQuery().locate("VIEWNAME", new Variant(string))) {
                this.tableViews.changeSelection(this.tableViews.getQuery().getCurrentRecord().getIndex(), this.tableViews.getSelectedColumn());
            } else if (!this.tableViews.getQuery().isEmpty()) {
                this.tableViews.changeSelection(Math.min(n, this.tableViews.getRowCount() - 1), this.tableViews.getSelectedColumn());
            }
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
    }

    private void addInfoPanel(String string, JPanel jPanel) {
        this.tabbedViewInfo.addTab(string, jPanel);
        this.tabbedViewInfo.setTabComponentAt(this.tabbedViewInfo.indexOfComponent(jPanel), (Component)new TabCloseComponent(string));
    }

    public boolean canClose() {
        return true;
    }

    public void close() throws IOException {
        this.viewClosing = true;
        int n = 0;
        while (n < this.tabbedViewInfo.getTabCount()) {
            Component component = this.tabbedViewInfo.getComponentAt(n);
            if (component instanceof Closeable) {
                try {
                    ((Closeable)((Object)component)).close();
                }
                catch (IOException iOException) {}
            } else {
                ++n;
            }
            this.tabbedViewInfo.remove(component);
        }
        this.tableViews.getQuery().close();
        this.accesibilities = null;
    }

    public Database getDatabase() {
        return this.accesibilities.getDatabase();
    }

    private void initComponents() {
        this.cmRefresh = new Action();
        this.cmSelectSchema = new Action();
        this.cmFilter = new Action();
        this.cmDropView = new Action();
        this.splinPane = new JSplitPane();
        this.panelViews = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableViews = new ViewTable();
        this.statusBarViews = new QueryTableStatusBar();
        this.jPanel1 = new JPanel();
        this.toolBarViews = new JToolBar();
        this.buttonRefresh = new ToolButton();
        this.buttonSelectSchema = new ToolButton();
        this.buttonFilter = new ToolButton();
        this.jSeparator1 = new JSeparator();
        this.buttonDtopView = new ToolButton();
        this.tabbedViewInfo = new JTabbedPane();
        this.cmRefresh.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/refresh16.gif"));
        this.cmRefresh.setText(stringManager.getString("cmRefresh-text"));
        this.cmRefresh.setTooltip(stringManager.getString("cmRefresh-hint"));
        this.cmRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewsPanelView.this.cmRefreshActionPerformed(actionEvent);
            }
        });
        this.cmSelectSchema.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/users16.gif"));
        this.cmSelectSchema.setText(stringManager.getString("cmSelectSchema-text"));
        this.cmSelectSchema.setTooltip(stringManager.getString("cmSelectSchema-hint"));
        this.cmSelectSchema.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewsPanelView.this.cmSelectSchemaActionPerformed(actionEvent);
            }
        });
        this.cmFilter.setActionCommandKey("cmFilter");
        this.cmFilter.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/orbada/derbydb/res/icons/filter16.gif"));
        this.cmFilter.setText(stringManager.getString("cmFilter-text"));
        this.cmFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewsPanelView.this.cmFilterActionPerformed(actionEvent);
            }
        });
        this.cmDropView.setActionCommandKey("cmDropTable");
        this.cmDropView.setSmallIcon((Icon)ImageManager.getImage((String)"/pl/mpak/res/icons/trash.gif"));
        this.cmDropView.setText(stringManager.getString("ViewsPanelView-cmDropView-text"));
        this.cmDropView.setTooltip(stringManager.getString("ViewsPanelView-cmDropView-hint"));
        this.cmDropView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ViewsPanelView.this.cmDropViewActionPerformed(actionEvent);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ViewsPanelView.this.formComponentShown(componentEvent);
            }
        });
        this.setLayout(new BorderLayout());
        this.splinPane.setBorder(null);
        this.splinPane.setDividerLocation(200);
        this.splinPane.setContinuousLayout(true);
        this.splinPane.setOneTouchExpandable(true);
        this.panelViews.setPreferredSize(new Dimension(250, 100));
        this.panelViews.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView((Component)this.tableViews);
        this.panelViews.add((Component)this.jScrollPane1, "Center");
        this.statusBarViews.setShowFieldType(false);
        this.statusBarViews.setShowFieldValue(false);
        this.statusBarViews.setShowOpenTime(false);
        this.panelViews.add((Component)this.statusBarViews, "Last");
        this.jPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.toolBarViews.setFloatable(false);
        this.toolBarViews.setRollover(true);
        this.buttonRefresh.setAction((javax.swing.Action)this.cmRefresh);
        this.buttonRefresh.setHorizontalTextPosition(0);
        this.buttonRefresh.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonRefresh);
        this.buttonSelectSchema.setAction((javax.swing.Action)this.cmSelectSchema);
        this.buttonSelectSchema.setHorizontalTextPosition(0);
        this.buttonSelectSchema.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonSelectSchema);
        this.buttonFilter.setAction((javax.swing.Action)this.cmFilter);
        this.buttonFilter.setHorizontalTextPosition(0);
        this.buttonFilter.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonFilter);
        this.jSeparator1.setOrientation(1);
        this.toolBarViews.add(this.jSeparator1);
        this.buttonDtopView.setAction((javax.swing.Action)this.cmDropView);
        this.buttonDtopView.setHorizontalTextPosition(0);
        this.buttonDtopView.setVerticalTextPosition(3);
        this.toolBarViews.add((Component)this.buttonDtopView);
        this.jPanel1.add(this.toolBarViews);
        this.panelViews.add((Component)this.jPanel1, "North");
        this.splinPane.setLeftComponent(this.panelViews);
        this.tabbedViewInfo.setFocusable(false);
        this.splinPane.setRightComponent(this.tabbedViewInfo);
        this.add((Component)this.splinPane, "Center");
    }

    private void cmDropViewActionPerformed(ActionEvent actionEvent) {
        if (this.tableViews.getSelectionModel().getLeadSelectionIndex() >= 0) {
            try {
                this.tableViews.getQuery().getRecord(this.tableViews.getSelectionModel().getLeadSelectionIndex());
                String string = SQLUtil.createSqlName((String)this.currentSchemaName, (String)this.tableViews.getQuery().fieldByName("viewname").getString(), (Database)this.getDatabase());
                if (MessageBox.show((Component)null, (String)stringManager.getString("deleting"), (String)stringManager.getString("ViewsPanelView-delete-view-q"), (int[])ModalResult.YESNO) == 5) {
                    this.getDatabase().createCommand("drop view " + string, true);
                    this.refresh(null);
                }
            }
            catch (Exception exception) {
                MessageBox.show((String)stringManager.getString("error"), (String)exception.getMessage(), (int)1);
                ExceptionUtil.processException((Throwable)exception);
            }
        }
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        if (!this.tableViews.getQuery().isActive()) {
            this.refresh();
        }
    }

    private void cmFilterActionPerformed(ActionEvent actionEvent) {
        if (SqlFilterDialog.show((SqlFilter)this.filter)) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmSelectSchemaActionPerformed(ActionEvent actionEvent) {
        Query query = this.getDatabase().createQuery();
        try {
            query.open("select schemaname from sys.sysschemas order by schemaname");
            Vector vector = QueryUtil.staticData((String)"{schemaname}", (Query)query);
            Point point = this.buttonSelectSchema.getLocationOnScreen();
            point.y += this.buttonSelectSchema.getHeight();
            SimpleSelectDialog.select((Window)SwingUtil.getWindowComponent((Component)this), (int)point.x, (int)point.y, (Vector)vector, (int)vector.indexOf(this.currentSchemaName), (SimpleSelectDialog.CallBack)new SimpleSelectDialog.CallBack(){

                public void selected(Object object) {
                    ViewsPanelView.this.setCurrentSchemaName(object.toString());
                    ViewsPanelView.this.refresh();
                }
            });
        }
        catch (Exception exception) {
            ExceptionUtil.processException((Throwable)exception);
        }
        finally {
            query.close();
        }
    }

    private void cmRefreshActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }
}

