/*
 * Decompiled with CFR 0.152.
 */
package pl.mpak.orbada.core;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import pl.mpak.g2.G2Util;
import pl.mpak.g2.RasterFont;
import pl.mpak.orbada.Consts;
import pl.mpak.orbada.OrbadaCancelCloseException;
import pl.mpak.orbada.OrbadaException;
import pl.mpak.orbada.core.OrbadaPluginManager;
import pl.mpak.orbada.db.InternalDatabase;
import pl.mpak.orbada.db.Orbada;
import pl.mpak.orbada.db.OrbadaSession;
import pl.mpak.orbada.db.User;
import pl.mpak.orbada.gui.LoginDialog;
import pl.mpak.orbada.gui.LoginInfo;
import pl.mpak.orbada.gui.MainFrame;
import pl.mpak.orbada.gui.PerspectivePanel;
import pl.mpak.orbada.gui.cm.HelpAction;
import pl.mpak.orbada.plugins.ApplicationListener;
import pl.mpak.orbada.plugins.GeneratorException;
import pl.mpak.orbada.plugins.IApplication;
import pl.mpak.orbada.plugins.IGenerator;
import pl.mpak.orbada.plugins.IPerspectiveAccesibilities;
import pl.mpak.orbada.plugins.IProcessMessagable;
import pl.mpak.orbada.plugins.ISettings;
import pl.mpak.orbada.plugins.IWebAppAccessibilities;
import pl.mpak.orbada.plugins.PleaseWait;
import pl.mpak.orbada.plugins.providers.ILookAndFeelStarter;
import pl.mpak.orbada.plugins.queue.PluginMessage;
import pl.mpak.orbada.util.Generator;
import pl.mpak.orbada.util.patt.CurrDateResolver;
import pl.mpak.orbada.util.patt.CurrTimeResolver;
import pl.mpak.orbada.util.patt.JvmPIDResolver;
import pl.mpak.orbada.util.patt.OrbadaConfigPath;
import pl.mpak.orbada.util.patt.OrbadaHomePath;
import pl.mpak.orbada.util.patt.OrbadaUserIdResolver;
import pl.mpak.orbada.util.patt.OrbadaUserNameResolver;
import pl.mpak.orbada.util.patt.SHA1_Password_AESResolver;
import pl.mpak.orbada.util.patt.UniqueIdResolver;
import pl.mpak.orbada.util.settings.SettingsFactory;
import pl.mpak.orbada.util.tools.ToolList;
import pl.mpak.orbada.webapp.WebAppAccessibilities;
import pl.mpak.plugins.spi.IPluginProvider;
import pl.mpak.sky.gui.swing.Action;
import pl.mpak.sky.gui.swing.ActionGlobalEvent;
import pl.mpak.sky.gui.swing.ActionGlobalListener;
import pl.mpak.sky.gui.swing.ImageManager;
import pl.mpak.sky.gui.swing.MessageBox;
import pl.mpak.sky.gui.swing.SwingUtil;
import pl.mpak.usedb.UseDBException;
import pl.mpak.usedb.core.Command;
import pl.mpak.usedb.core.Database;
import pl.mpak.usedb.core.Query;
import pl.mpak.util.ExceptionUtil;
import pl.mpak.util.ProcessExceptionListener;
import pl.mpak.util.StringManager;
import pl.mpak.util.StringManagerFactory;
import pl.mpak.util.StringUtil;
import pl.mpak.util.SystemUtil;
import pl.mpak.util.id.UniqueID;
import pl.mpak.util.id.VersionID;
import pl.mpak.util.patt.ResolvableModel;
import pl.mpak.util.patt.Resolvers;
import pl.mpak.util.variant.Variant;

public class Application
implements IApplication,
WindowListener {
    private static final StringManager stringManager = StringManagerFactory.getStringManager(Consts.class);
    private static Application application;
    private String[] ordabaArguments;
    private MainFrame mainFrame;
    private OrbadaPluginManager pluginManager;
    private Logger logger;
    private Properties properties;
    private ToolList toolList;
    public Properties localProperties;
    private File localPropertiesFile;
    private boolean safeMode = false;
    private boolean multiUser;
    private VersionID lastVersion;
    private final ArrayList<IProcessMessagable> messagerList = new ArrayList();
    private HashMap<String, ISettings> settingsList;
    private HashMap<String, IGenerator> generatorList;
    private ISettings applicationSettings;
    private User user;
    private OrbadaSession orbadaSession;
    private WebAppAccessibilities webAppAccessibilities;
    private static SplashScreen splash;
    private static Graphics2D splashGraphics;
    private static int splashSize;
    private static int splashCounter;
    private boolean firstRun;
    private static Image orbadaSplashLogo;
    private static final String fontChars = "A\u0104BC\u0106DE\u0118FGHIJKL\u0141MN\u0143O\u00d3PQRS\u015aTUVWXYZ\u017b\u01790123456789!@#$%^&*()-=_+[]{};':\",./<>?|\\";
    private static BufferedImage fontsImage;
    private static RasterFont fonts;
    private static BufferedImage fontsSmallImage;
    private static RasterFont fontsSmall;
    private int exitCode = 0;
    private final EventListenerList applicationListenerList = new EventListenerList();

    public static void main(String[] args) {
        application = new Application(args);
        application.init();
    }

    private void init() {
        this.initGraphics();
        Application.renderSplashText(stringManager.getString("Application-initialization-3dot"));
        this.initActionStats();
        this.initResolvers();
        this.initLocalProperties();
        this.initProperties();
        this.initLogger();
        this.initLAF();
        this.initAWTWindowEvents();
        this.settingsList = new HashMap();
        this.generatorList = new HashMap();
        this.webAppAccessibilities = new WebAppAccessibilities();
        this.initExceptionUtil();
        InternalDatabase.init();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalDatabase.beforeLogin();
                Application.this.loginUser();
                InternalDatabase.afterLogin();
                Application.this.toolList = new ToolList();
                Application.this.initSession();
                Application.renderSplashText(stringManager.getString("Application-init-tools-3dot"));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Application.this.initPluginManager();
                        Application.renderSplashText(stringManager.getString("Application-prepare-service-3dot"));
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Application.this.mainFrame = new MainFrame();
                                Application.this.mainFrame.addWindowListener(Application.this);
                                Application.this.pluginManager.initializePlugins();
                                Application.this.mainFrame.initGlobalServices();
                                Application.this.mainFrame.setVisible(true);
                                Application.this.mainFrame.afterInit();
                                Application.closeSplashScreen();
                            }
                        });
                    }
                });
            }
        });
    }

    public Application(String[] args) {
        this.ordabaArguments = args;
    }

    private void initGraphics() {
        if (orbadaSplashLogo == null) {
            orbadaSplashLogo = ImageManager.getImage((String)"/res/orbada-splash.png").getImage();
            orbadaSplashLogo = orbadaSplashLogo.getScaledInstance(46, 46, 1);
        }
        if (fontsImage == null) {
            fontsImage = G2Util.createImage((URL)this.getClass().getResource("/res/fonts.png"));
            fonts = new RasterFont(fontsImage, fontChars, -3);
            fontsSmallImage = G2Util.createImage((URL)this.getClass().getResource("/res/fonts-sm.png"));
            fontsSmall = new RasterFont(fontsSmallImage, fontChars, -2);
        }
    }

    private void initAWTWindowEvents() {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){
            HelpAction cmHelp = new HelpAction();

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 200) {
                    if (event.getSource() instanceof JDialog) {
                        SwingUtil.addAction((JDialog)((JDialog)event.getSource()), (String)this.cmHelp.getActionCommandKey(), (javax.swing.Action)((Object)this.cmHelp));
                    }
                } else if (event.getID() == 202) {
                    // empty if block
                }
            }
        }, 64L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String inputFile, File outputFile) {
        try {
            InputStream is = this.getClass().getResource(inputFile).openStream();
            FileOutputStream os = new FileOutputStream(outputFile);
            try {
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = is.read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, i);
                }
            }
            finally {
                is.close();
                ((OutputStream)os).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public String getConfigFile() {
        String configFile = "orbada";
        for (String arg : this.ordabaArguments) {
            if (!StringUtil.equals((String)StringUtil.argName((String)arg), (String)"config")) continue;
            configFile = StringUtil.argValue((String)arg);
            break;
        }
        return this.getConfigPath() + "/" + configFile + ".properties";
    }

    private void initLocalProperties() {
        this.localPropertiesFile = new File(this.getConfigPath() + "/local-settings.properties");
        this.localProperties = new Properties();
        if (this.localPropertiesFile.exists()) {
            try {
                this.localProperties.load(new FileInputStream(this.localPropertiesFile));
            }
            catch (IOException ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void initProperties() {
        String configFile = this.getConfigFile();
        File file = new File(configFile);
        if (!file.exists()) {
            this.copyFile("/res/orbada.properties", file);
            File filejgoodies = new File(this.getConfigPath() + "/laf-jgoodies.properties");
            if (!filejgoodies.exists()) {
                this.copyFile("/res/laf-jgoodies.properties", filejgoodies);
            }
        }
        System.out.println("Using config file: " + file);
        this.properties = new Properties();
        try {
            this.properties.load(new FileInputStream(file));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        if (StringUtil.toBoolean((String)this.getProperty("sha1-password-aes"))) {
            Resolvers.register((ResolvableModel)new SHA1_Password_AESResolver());
        }
    }

    public void updateLAF() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.this.initLAF();
                try {
                    SwingUtilities.updateComponentTreeUI(Application.this.getMainFrame());
                    Component comp = FocusManager.getCurrentManager().getFocusOwner();
                    Window current = (Window)SwingUtil.getOwnerComponent(Window.class, (Component)comp);
                    if (Application.this.getMainFrame() != current && current != null) {
                        SwingUtilities.updateComponentTreeUI(current);
                    }
                }
                catch (Throwable ex) {
                    ExceptionUtil.processException((Throwable)ex);
                }
            }
        });
    }

    private void initLAF() {
        try {
            String orbadaLafClassName;
            if (SystemUtil.isMacOs()) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            if (!StringUtil.isEmpty((String)(orbadaLafClassName = this.localProperties.getProperty("orbada.laf.class", this.getProperty("orbada.laf.class"))))) {
                Logger.getLogger("orbada").info("Orbada LAF from \"orbada.laf.class\" property: " + orbadaLafClassName);
                Class<?> lafClass = Class.forName(orbadaLafClassName);
                Object lafObject = lafClass.newInstance();
                if (lafObject instanceof ILookAndFeelStarter) {
                    ((ILookAndFeelStarter)lafObject).setApplication((IApplication)this);
                    ((ILookAndFeelStarter)lafObject).start();
                } else {
                    Logger.getLogger("orbada").error("Orbada LAF from \"orbada.laf.class\" is not implementation of ILookAndFeelStarter");
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } else {
                String className = this.localProperties.getProperty("laf.class", this.getProperty("laf.class"));
                if (className != null) {
                    if (!"".equals(className.trim())) {
                        UIManager.setLookAndFeel(className);
                        Logger.getLogger("orbada").info("LAF from \"laf.class\" property: " + className);
                    } else {
                        Logger.getLogger("orbada").info("LAF from \"laf.class\" property: none");
                    }
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    Logger.getLogger("orbada").info("LAF Orbada default: " + UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Throwable ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    private void initActionStats() {
        Action.addActionGlobalListener((ActionGlobalListener)new ActionGlobalListener(){

            public void beforeAction(ActionGlobalEvent e) {
            }

            public void afterAction(ActionGlobalEvent e) {
            }
        });
    }

    private void initResolvers() {
        Resolvers.register((ResolvableModel)new CurrDateResolver());
        Resolvers.register((ResolvableModel)new CurrTimeResolver());
        Resolvers.register((ResolvableModel)new UniqueIdResolver());
        Resolvers.register((ResolvableModel)new OrbadaHomePath());
        Resolvers.register((ResolvableModel)new OrbadaConfigPath());
        Resolvers.register((ResolvableModel)new JvmPIDResolver());
    }

    public String getLogFile() {
        String log4jFile = "log4j.xml";
        for (String arg : this.ordabaArguments) {
            if (!StringUtil.equals((String)StringUtil.argName((String)arg), (String)"log4j")) continue;
            log4jFile = StringUtil.argValue((String)arg);
            break;
        }
        return this.getConfigPath() + "/" + log4jFile;
    }

    private void initLogger() {
        String log4jFile = this.getLogFile();
        File file = new File(log4jFile);
        if (!file.exists()) {
            this.copyFile("/res/log4j.xml", file);
        }
        System.out.println("Using logger config file: " + file);
        this.logger = Logger.getLogger("orbada");
        DOMConfigurator.configure(log4jFile);
        this.logger.debug("Orbada starting...");
    }

    private void initPluginManager() {
        Application.renderSplashText(stringManager.getString("Application-init-plugins-3dot"));
        this.pluginManager = new OrbadaPluginManager(this.logger);
        this.pluginManager.getPluginQueue().setExtendedMessagerList(this.messagerList);
        this.pluginManager.findPlugins();
        this.pluginManager.loadPlugins();
    }

    private void initExceptionUtil() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ExceptionUtil.processException((Throwable)e);
            }
        });
        ExceptionUtil.addProcessExceptionListener((ProcessExceptionListener)new ProcessExceptionListener(){

            public void processException(EventObject event) {
                if (event.getSource() instanceof OrbadaCancelCloseException) {
                    return;
                }
                Logger.getLogger("error-logger").error("ExceptionUtil", (Throwable)event.getSource());
                ((Throwable)event.getSource()).printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loginUser() {
        Logger.getLogger("orbada").info("Login Orbada user...");
        Application.renderSplashText(stringManager.getString("Application-login-user-3dot"));
        if (InternalDatabase.get() == null) {
            this.user = new User(InternalDatabase.get());
            return;
        }
        try {
            Query query = InternalDatabase.get().createQuery();
            try {
                query.setCloseResultAfterOpen(true);
                query.open("select count( 0 ) cnt from users where usr_orbada is null and usr_active = 'T'");
                if (query.fieldByName("cnt").getInteger() == 0) {
                    this.user = new User(InternalDatabase.get());
                    this.user.fieldByName("usr_name").setValue(new Variant(System.getProperty("user.name").toLowerCase()));
                    this.user.fieldByName("usr_admin").setValue(new Variant("Y"));
                    this.user.applyInsert();
                } else if (query.fieldByName("cnt").getInteger() == 1) {
                    query.open("select usr_id, usr_name, usr_password from users where usr_orbada is null and usr_active = 'T'");
                    if (!query.fieldByName("usr_password").isNull()) {
                        for (int tryCount = 3; tryCount > 0; --tryCount) {
                            LoginInfo info = LoginDialog.show(query.fieldByName("usr_name").getString(), "", stringManager.getString("Application-login-user"));
                            if (info == null) {
                                throw new OrbadaException(1002);
                            }
                            if (query.fieldByName("usr_password").getString().equals(info.getPassword())) break;
                            if (tryCount != 0) continue;
                            throw new OrbadaException(1003);
                        }
                    }
                    this.user = new User(InternalDatabase.get(), query.fieldByName("usr_id").getString());
                } else {
                    this.multiUser = true;
                    String userName = this.localProperties.getProperty("last-logged-user-name", "");
                    for (int tryCount = 3; tryCount > 0; --tryCount) {
                        LoginInfo info = LoginDialog.show(userName, "", stringManager.getString("Application-login-user"));
                        if (info == null) {
                            throw new OrbadaException(1002);
                        }
                        userName = info.getUserName();
                        query.setSqlText("select usr_id, usr_password from users where usr_name = :usr_name");
                        query.paramByName("usr_name").setString(userName.toLowerCase());
                        query.open();
                        if (query.isEmpty() || query.fieldByName("usr_password").getString().equals(info.getPassword())) break;
                        if (tryCount != 0) continue;
                        throw new OrbadaException(1003);
                    }
                    this.user = new User(InternalDatabase.get(), query.fieldByName("usr_id").getString());
                    this.localProperties.put("last-logged-user-name", userName);
                }
            }
            finally {
                query.close();
            }
            Resolvers.register((ResolvableModel)new OrbadaUserIdResolver());
            Resolvers.register((ResolvableModel)new OrbadaUserNameResolver());
            Logger.getLogger("orbada").info(String.format("Orbada user \"%s\" loged", this.user.getUserName()));
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
            if (ex instanceof OrbadaException && !"ORBADA-01002".equals(((OrbadaException)((Object)ex)).getCode())) {
                MessageBox.show(null, (String)stringManager.getString("error"), (String)ex.getMessage(), (int)1, (int)0);
            }
            System.exit(-1);
        }
    }

    private void initSession() {
        if (this.getOrbadaDatabase() == null) {
            return;
        }
        this.orbadaSession = new OrbadaSession(this.getOrbadaDatabase());
        this.orbadaSession.setStartTime(Long.valueOf(new Date().getTime()));
        this.orbadaSession.setUsrId(this.getUserId());
        this.orbadaSession.setVersion(Consts.orbadaVersion.toString());
        try {
            this.orbadaSession.applyInsert();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        Resolvers.register((ResolvableModel)new ResolvableModel(){

            public String getModel() {
                return "orbada.session.id";
            }

            public String getResolve() {
                return Application.this.orbadaSession.getId();
            }
        });
        if (!this.isMultiUserApp()) {
            long days = Long.parseLong(this.getProperty("session.delete-days", "10"));
            Command command = this.getOrbadaDatabase().createCommand();
            try {
                command.setSqlText("delete from orbada_sessions where oses_start_time < :data");
                command.paramByName("data").setTimestamp(new Timestamp(System.currentTimeMillis() - days * 24L * 60L * 60L * 1000L));
                command.execute();
                command.setSqlText("delete from schema_sessions where sses_start_time < :data");
                command.paramByName("data").setTimestamp(new Timestamp(System.currentTimeMillis() - days * 24L * 60L * 60L * 1000L));
                command.execute();
            }
            catch (Exception ex) {
                ExceptionUtil.processException((Throwable)ex);
            }
        }
    }

    private void doneSession() {
        this.orbadaSession.setEndTime(Long.valueOf(new Date().getTime()));
        try {
            this.orbadaSession.applyUpdate();
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public static void closeSplashScreen() {
        if (splash != null && splash.isVisible()) {
            splash.close();
            splashGraphics = null;
            splash = null;
        }
    }

    public static void drawSplashInfo(Graphics2D g2, Rectangle bounds) {
        int y = 10;
        g2.drawImage(orbadaSplashLogo, bounds.width - 10 - orbadaSplashLogo.getWidth(null), 25, null);
        fonts.draw(15, y, (Graphics)g2, "ORBADA");
        fontsSmall.draw(18, y += fonts.getHeight() - 5, (Graphics)g2, "Dzianisz, Polska".toUpperCase());
        fontsSmall.draw(18, y += fontsSmall.getHeight("Dzianisz, Polska".toUpperCase()), (Graphics)g2, Consts.orbadaVersion.toString(VersionID.VersionString.vsLong).toUpperCase());
        fontsSmall.draw(18, y += fontsSmall.getHeight() * 2, (Graphics)g2, "Andrzej Ka\u0142u\u017ca".toUpperCase());
        fontsSmall.draw(18, y += fontsSmall.getHeight(), (Graphics)g2, "(C) " + "2007-2015".toUpperCase());
    }

    public static void renderSplashText(final String text) {
        ++splashCounter;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (splash != null && splash.isVisible()) {
                    if (splashGraphics == null) {
                        splashGraphics = splash.createGraphics();
                    }
                    splashGraphics.setComposite(AlphaComposite.Clear);
                    Rectangle b = splash.getBounds();
                    splashGraphics.fillRect(20, b.height - 20 - 18, b.width - 40, 20);
                    splashGraphics.setPaintMode();
                    splashGraphics.setColor(Color.BLACK);
                    if (Application.get().isFirstRun()) {
                        splashGraphics.drawString(Consts.orbadaFirstRun, 22, b.height - 20 - 27);
                    }
                    splashGraphics.drawString(text, 22, b.height - 20 - 7);
                    splashGraphics.setColor(new Color(20, 53, 70));
                    splashGraphics.drawRect(19, b.height - 20 - 2, b.width - 40 + 2, 6);
                    splashGraphics.fillRect(21, b.height - 20 - 0, (int)((double)(b.width - 42) * ((double)splashCounter / (double)splashSize)), 3);
                    Composite oc = splashGraphics.getComposite();
                    splashGraphics.setComposite(AlphaComposite.Src);
                    Application.drawSplashInfo(splashGraphics, b);
                    splashGraphics.setComposite(oc);
                    splash.update();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        EventListenerList eventListenerList = this.applicationListenerList;
        synchronized (eventListenerList) {
            this.applicationListenerList.add(ApplicationListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener listener) {
        EventListenerList eventListenerList = this.applicationListenerList;
        synchronized (eventListenerList) {
            this.applicationListenerList.remove(ApplicationListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireApplicationListener(ApplicationEvent event) {
        EventListenerList eventListenerList = this.applicationListenerList;
        synchronized (eventListenerList) {
            ApplicationListener[] listeners = (ApplicationListener[])this.applicationListenerList.getListeners(ApplicationListener.class);
            block10: for (int i = 0; i < listeners.length; ++i) {
                switch (event) {
                    case ACTIVATED: {
                        listeners[i].activated();
                        continue block10;
                    }
                    case DEACTIVATED: {
                        listeners[i].deactivated();
                        continue block10;
                    }
                    case ICONIFIED: {
                        listeners[i].iconified();
                        continue block10;
                    }
                    case DEICONIFIED: {
                        listeners[i].deiconified();
                        continue block10;
                    }
                    case CLOSING: {
                        listeners[i].closing();
                    }
                }
            }
        }
    }

    public static Application get() {
        return application;
    }

    public String[] getArguments() {
        return this.ordabaArguments;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ISettings getSettings() {
        if (this.applicationSettings == null) {
            this.applicationSettings = this.getSettings("orbada-settings");
        }
        return this.applicationSettings;
    }

    public void registerDriverType(String driverType) {
        InternalDatabase.registerDriverType(driverType);
    }

    public void addStatusBar(Component component) {
        this.mainFrame.addStatusBar(component);
    }

    public void removeStatusBar(Component component) {
        this.mainFrame.removeStatusBar(component);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.fireApplicationListener(ApplicationEvent.ACTIVATED);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.windowClosing(e);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.logger.debug("Orbada closing...");
        this.fireApplicationListener(ApplicationEvent.CLOSING);
        this.pluginManager.unloadPlugins();
        InternalDatabase.done();
        this.logger.debug("Orbada closing: Okay");
        System.exit(this.exitCode);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.fireApplicationListener(ApplicationEvent.DEACTIVATED);
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.fireApplicationListener(ApplicationEvent.DEICONIFIED);
    }

    @Override
    public void windowIconified(WindowEvent e) {
        this.fireApplicationListener(ApplicationEvent.ICONIFIED);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public String getSettingsPath() {
        File file = new File(Resolvers.expand((String)"$(orbada.home)"));
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public String getConfigPath() {
        File file = new File(Resolvers.expand((String)"$(orbada.config)"));
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public ISettings getSettings(String groupName) {
        ISettings result = this.settingsList.get(groupName.toUpperCase());
        if (result == null) {
            result = SettingsFactory.createInstance(groupName);
            this.settingsList.put(groupName.toUpperCase(), result);
        }
        return result;
    }

    public ISettings getSettings(String schemaId, String groupName) {
        ISettings result = this.settingsList.get(schemaId + ":" + groupName.toUpperCase());
        if (result == null) {
            result = SettingsFactory.createInstance(schemaId, groupName);
            this.settingsList.put(schemaId + ":" + groupName.toUpperCase(), result);
        }
        return result;
    }

    public void addAction(Action action) {
        this.mainFrame.addAction(action);
    }

    public void removeAction(Action action) {
        this.mainFrame.removeAction(action);
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public OrbadaPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public <T extends IPluginProvider> T[] getServiceArray(Class<T> t) {
        return this.getPluginManager().getServiceArray(t);
    }

    public void postPluginMessage(PluginMessage message) {
        try {
            this.pluginManager.getPluginQueue().post(message);
        }
        catch (InterruptedException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRequestMessager(IProcessMessagable processMessagable) {
        ArrayList<IProcessMessagable> arrayList = this.messagerList;
        synchronized (arrayList) {
            if (this.messagerList.indexOf(processMessagable) == -1) {
                this.messagerList.add(processMessagable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRequestMessager(IProcessMessagable processMessagable) {
        ArrayList<IProcessMessagable> arrayList = this.messagerList;
        synchronized (arrayList) {
            this.messagerList.remove(processMessagable);
        }
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        if ("orbada.update.page".equals(name)) {
            return "";
        }
        if ("orbada.web.page".equals(name)) {
            return "";
        }
        return this.properties.getProperty(name, defaultValue);
    }

    public String getOrbadaString(String name) {
        return this.getOrbadaString(name, null);
    }

    public String getOrbadaString(String name, String defaultValue) {
        try {
            Orbada orbada = new Orbada(this.getOrbadaDatabase(), Application.get().getUserId(), name);
            if (orbada.getValue() == null) {
                return defaultValue;
            }
            return orbada.getValue();
        }
        catch (UseDBException ex) {
            return defaultValue;
        }
    }

    public void setOrbadaString(String name, String value) {
        try {
            Orbada orbada = new Orbada(this.getOrbadaDatabase(), Application.get().getUserId(), name);
            orbada.setValue(value);
            if (orbada.isExists()) {
                orbada.applyUpdate();
            } else {
                orbada.setId(new UniqueID().toString());
                orbada.setName(name);
                orbada.setUsrId(Application.get().getUserId());
                orbada.applyInsert();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
    }

    public void shutDown() {
        Logger.getLogger("orbada").info("Orbada shutdown in progress...");
        this.getSettings().store();
        this.doneSession();
        try {
            this.localProperties.store(new FileOutputStream(this.localPropertiesFile), "Orbada Local Stored Settings");
        }
        catch (IOException ex) {
            ExceptionUtil.processException((Throwable)ex);
        }
        Logger.getLogger("orbada").info("Orbada shutdown Ok");
    }

    public void execTool(String command, Object[] args) {
        this.toolList.exec(command, args);
    }

    public ToolList getToolList() {
        return this.toolList;
    }

    public String getUserId() {
        return this.user.getUserId();
    }

    public String getUserName() {
        return this.user.getUserName();
    }

    public boolean isUserAdmin() {
        return this.user.isUserAdmin();
    }

    public boolean isMultiUserApp() {
        return this.multiUser;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    public IGenerator initGenerator(String name, BigInteger startValue, BigInteger minValue, BigInteger maxValue, BigInteger increment, Boolean cycle) throws GeneratorException {
        IGenerator generator = this.getGenerator(name);
        if (generator == null) {
            generator = new Generator(name, startValue, minValue, maxValue, increment, cycle);
            this.generatorList.put(name, generator);
        }
        return generator;
    }

    public IGenerator getGenerator(String name) {
        return this.generatorList.get(name);
    }

    public Database getOrbadaDatabase() {
        return InternalDatabase.get();
    }

    public IPerspectiveAccesibilities getActivePerspective() {
        PerspectivePanel panel = this.getMainFrame().getActivePerspective();
        if (panel != null) {
            return panel.getPerspectiveAccesibilities();
        }
        return null;
    }

    public String getOrbadaSessionId() {
        return this.orbadaSession.getId();
    }

    public IWebAppAccessibilities getWebAppAccessibilities() {
        return this.webAppAccessibilities;
    }

    public PleaseWait startPleaseWait(PleaseWait wait) {
        this.getMainFrame().getGlassPane().addPleaseWait(wait);
        return wait;
    }

    public void stopPleaseWait(PleaseWait wait) {
        this.getMainFrame().getGlassPane().removePleaseWait(wait);
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    public boolean isFirstRun() {
        return this.firstRun;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public RasterFont getOrbadaFont() {
        return fonts;
    }

    public RasterFont getOrbadaSmallFont() {
        return fontsSmall;
    }

    public VersionID getLastVersion() {
        return this.lastVersion;
    }

    public void setLastVersion(VersionID lastVersion) {
        this.lastVersion = lastVersion;
    }

    static {
        splash = SplashScreen.getSplashScreen();
        splashGraphics = null;
        splashSize = 10;
        splashCounter = 0;
    }

    public static enum ApplicationEvent {
        ACTIVATED,
        CLOSING,
        DEACTIVATED,
        ICONIFIED,
        DEICONIFIED;

    }
}

